#--
# Copyright (C) 2009 Harald Sitter <apachelogger@ubuntu.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License or (at your option) version 3 or any later version
# accepted by the membership of KDE e.V. (or its successor approved
# by the membership of KDE e.V.), which shall act as a proxy
# defined in Section 14 of version 3 of the license.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#++
# Wrapper library for the KDE utility kioclient.
#--

class KIOClient
    def initialize
        @kioclient = "kioclient"
    end

    def open_prop(address)
        %x[#{@kioclient} openProperties #{address}]
    end

    def execute(url,mime='')
        %x[#{@kioclient} exec #{url} #{mime}]
    end

    def move(source,target)
        %x[#{@kioclient} move #{source} #{target}]
    end

    def download(source='')
        %x[#{@kioclient} download #{source}]
    end

    def copy(source,target)
        %x[#{@kioclient} copy #{source} #{target}]
    end

    def cat(address)
        %x[#{@kioclient} cat #{address}]
    end

    def trash(url)
        move(url,"trash:/")
    end
end
