#/bin/bash
################################################################################
# Copyright (C) 2012 Little Girl <littlergirl@gmail.com>                       #
#                                                                              #
# This script examines the contents of the libs/global.ent file and displays a #
# list of all unused entities.                                                 #
#                                                                              #
# This is free software: you can redistribute it and/or modify it under the    #
# terms of the GNU General Public License as published by the Free Software    #
# Foundation, either version 3 of the License, or (at your option) any later   #
# version.                                                                     #
#                                                                              #
# This script is distributed in the hope that it will be useful, but WITHOUT   #
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or        #
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for     #
# more details.                                                                #
#                                                                              #
# You should have received a copy of the GNU General Public License along with #
# this script. If not, see http://www.gnu.org/licenses/.                       #
################################################################################
grep ENTITY ../libs/global.ent | cut -d" " -f2 | while read item;
do
	grep -q -r "&$item" ../*;
	if
		[ "$?" = 0 ];
	then
		:;
	elif
		[ "$?" = 1 ];
	then
		grep -q -r "gentext.$item" ../*;
		if
			[ "$?" = 0 ];
		then
			:;
		elif
			[ "$?" = 1 ];
		then
			echo "$item";
		else
			echo "ERROR";
		fi;
	else
		echo "All entities are being used.";
	fi;
done;
