#!/usr/bin/python

import creoleparser
import re
import string
import subprocess

outputDir = "temp"
baseUrl = "/"
website = "https://wiki.kubuntu.org/"

def debug(line):
  #print(line)
  pass

def process(wikiPageFile, page):
  wikiPageText = unicode("")
  for line in wikiPageFile:
    useLine = True
    if line.startswith("#"):
      useLine = False
    if line.startswith("----"):
      break
    if line.startswith(" /*"):
      line = ""
    if line.startswith("  *"):
      line = " **"+line[3:]
    
    if line.startswith("[[attachment:"):
      if "width" in line:
        match = re.match("(.*)\[\[attachment:((.*?)(\|.*)?{{(.*)\|width=(.*?)(\|.*)?}}(.*))", line)
        image = match.group(3)
        width = match.group(6)
        align = ""
        if "align" in line:
          match = re.match('(.*)\|align="(.*?)(\|.*)?"}}(.*)', line)
          align = match.group(2)
        line = "{{attachment:"+image+"}}"+"TOHTML:"+width+";PAGE:"+page+";ALIGN:"+align+";"
      else:
        match = re.match("(.*)\[\[attachment:((.*?)(\|.*)?{{(.*))", line)
        line = "{{attachment:"+match.group(3)+"}}"
      debug(line)
    
    line = string.replace(line, "[[https://wiki.kubuntu.org/", "[[")
    line = string.replace(line, "[[Kubuntu", "[["+baseUrl+"kubuntu")
    def addhtml(match):
      html = ""
      if match.group(1).startswith("[[/"):
        html = ".html"
      return match.group(1) + html + match.group(2) + match.group(3)
    line = re.sub("(\[\[.*?)(\|.*)?(\]\])", addhtml, line)
    if useLine and not "Include(" in line:
        wikiPageText +=unicode(line, 'utf-8')
    
    ## Includes
    if "Include(" in line and useLine:
      wikiPageText += include(line)
  return wikiPageText

def include(line):
  if "from=" in line:
    match = re.match("(.*)\((.*?)(\|.*)?,(.*)from=(.*?)(\|.*)?,(.*)to=(.*?)(\|.*)?\)", line)
    link= match.group(2)
    fromPoint = match.group(5)[1:-1]
    toPoint = match.group(8)[1:-1]
  else:
    match = re.match("(.*)\((.*?)(\|.*)?,(.*)to=(.*?)(\|.*)?\)", line)
    link= match.group(2)
    fromPoint = "None"
    toPoint = match.group(5)[1:-1]
  
  debug((link, fromPoint, toPoint))
  debug("wget --user-agent='Mozilla'  https://wiki.kubuntu.org/"+link+"?action=raw -O include -o /dev/null")
  subprocess.call("wget --user-agent='Mozilla'  https://wiki.kubuntu.org/"+link+"?action=raw -O include -o /dev/null", shell=True)
  
  includeFile = open('include')
  includeText = []
  include = False
  for lineInclude in includeFile:
    if toPoint in lineInclude:
      include = False
    
    if include == True:
      includeText.append(lineInclude)
    
    if fromPoint in lineInclude or fromPoint == "None":
      include = True
  
  wikiPageText = process(includeText, link)
  return wikiPageText

wikiPages = ["Kubuntu/KubuntuDocs",
             "Kubuntu/KubuntuDocs/Basic",
             "Kubuntu/KubuntuDocs/Basic/CommandLine",
              "Kubuntu/KubuntuDocs/Basic/ManagingRepositories",
              "Kubuntu/KubuntuDocs/Basic/ManagingSoftware",
              "Kubuntu/KubuntuDocs/GettingInvolved",
              #"Kubuntu/KubuntuDocs/Installation",
              #"Kubuntu/KubuntuDocs/Installation/DiskSetup",
              #"Kubuntu/KubuntuDocs/Installation/Keyboard",
              #"Kubuntu/KubuntuDocs/Installation/Timezone",
              #"Kubuntu/KubuntuDocs/Installation/UserInfo",
              #"Kubuntu/KubuntuDocs/Installing/Prepare",
              "Kubuntu/KubuntuDocs/KDETechnologies",
              "Kubuntu/KubuntuDocs/Software",
              "Kubuntu/KubuntuDocs/Software/Development",
              "Kubuntu/KubuntuDocs/Software/Games",
              "Kubuntu/KubuntuDocs/Software/Games/Steam",
              "Kubuntu/KubuntuDocs/Software/Graphics",
              "Kubuntu/KubuntuDocs/Software/Internet",
              "Kubuntu/KubuntuDocs/Software/Multimedia",
              "Kubuntu/KubuntuDocs/Software/Office",
              "Kubuntu/KubuntuDocs/Software/Utilities",
              "Kubuntu/KubuntuDocs/Welcome",
              "Kubuntu/KubuntuDocs/PhoneSupport",
            ]

## CSS and Header bits and pieces
cssFiles = ["2c-r-fixed.css",
	    "common.css",
	    "general.css",
	    "images.css",
	    "reset.css",
	    "screen.css",
	    "typography.css",
	    ]

cssDir = "moin_static192/kubuntu-light/css/"
subprocess.call("mkdir -p "+outputDir+"/Kubuntu/css", shell=True)
debug("mkdir -p "+outputDir+"/Kubuntu/css")
for cssFile in cssFiles:
  subprocess.call("wget --user-agent='Mozilla' "+website+"/"+cssDir+"/"+cssFile+" -O "+outputDir+"/Kubuntu/css/"+cssFile+" -o /dev/null", shell=True)

subprocess.call("sed s,kubuntu-wiki.png,kubuntu-docs.png, "+outputDir+"/Kubuntu/css/general.css -i", shell=True)

headerImages = ["dotted-bg.png",
                "favicon.ico",
                "feed-icon-10x10.png",
                "footer-bg.png",
                "header-bg-hover.png",
                "header-bg.png",
                "kubuntu-wiki.png",
                "kubuntu-wiki.svg",
                "nobody.png",
                "orangeheader-tile.png",
                "orangeheader.png",
                "search_button_sprite.png",
                "sidebox_stripes.png",
                "slider-arrows.png",
                "ubuntu-logo.png",
                "ubuntu-planet.png",   
                "ubuntu-wiki.png",]

imageDir = "moin_static192/kubuntu-light/images/"
subprocess.call("mkdir -p "+outputDir+"/Kubuntu/images", shell=True)
debug("mkdir -p "+outputDir+"/Kubuntu/images")
for image in headerImages:
  subprocess.call("wget --user-agent='Mozilla' "+website+"/"+imageDir+"/"+image+" -O "+outputDir+"/Kubuntu/images/"+image+" -o /dev/null", shell=True)

for wikiPage in wikiPages:
  debug("wikipage " + wikiPage)
  directory = wikiPage.rsplit("/", 1)[0]
  debug("directory " + directory)
  subprocess.call("mkdir -p "+outputDir+"/"+directory, shell=True)
  debug("mkdir -p "+outputDir+"/"+directory)
  
  subprocess.call("wget --user-agent='Mozilla' https://wiki.kubuntu.org/"+wikiPage+"?action=raw -O wikipage -o /dev/null", shell=True)
  wikiPageFile = open("wikipage")
  wikiPageText = process(wikiPageFile, wikiPage)
  
  ## Title
  title = wikiPage.split("/")
  title = title[len(title)-1]
  
  link = string.replace(wikiPage, "Kubuntu/", "kubuntu/")
  
  html = "<h2 class='entry-title'>\n" +\
    "<span><a href='/"+link+".html'>"+title+"</a></span>\n" +\
    "</h2>\n"
  
  
  html += creoleparser.creole2html(wikiPageText)

  ## Post process fixes
  htmlLines = html.split("\n")
  htmlOutput = ""
  for line in htmlLines:
    ## Images
    if "{{attachment:" in line:
      if "TOHTML" in line:
        match = re.match("(.*){{attachment:(.*?)(\|.*)?}}(.*)TOHTML:(.*?)(\|.*)?;(.*)PAGE:(.*?)(\|.*)?;(.*)ALIGN:(.*?)(\|.*)?;(.*)", line)
        width = match.group(5)
        page = match.group(8)
        align = match.group(11)
      else:
        match = re.match("(.*){{attachment:(.*?)(\|.*)?}}(.*?)", line)
        width = ""
        page = wikiPage
      image = match.group(2)
      if image[-5:] == ".html":
        image = image[:-5]
      subprocess.call("wget https://wiki.kubuntu.org/"+page+"?action=AttachFile\&do=get\&target="+image+\
                      " -O "+outputDir+"/"+directory+"/"+image+" -o /dev/null", shell=True)
      
      if "<a" in line:
        link = "</a>"
      else:
        link = ""
      
      if width:
        if align == "":
          line = match.group(1) + "<img src='"+image+"' width='"+width+"' align='"+align+"' />"+link+"<br />"
        else:
          line = match.group(1) + "<img src='"+image+"' width='"+width+"' align='"+align+"' />"+link
      else:
        line = match.group(1) + "<img src='"+image+"' />"+link
    
    ## Bold text
    elif "'''" in line:
      done = 0
      while done == 0:
        match = re.match("(.*)\'\'\'(.*?)(\|.*)?\'\'\'(.*)", line)
        line = match.group(1)+"<b>"+match.group(2)+"</b>"+match.group(4)
        if not "'''" in line:
          done = 1
    elif "Guided - use entire disk." in line:
      debug(line)
    htmlOutput += line + "\n"
  
  ## Make the table of content
  htmlLines = htmlOutput.split("\n")
  htmlOutput = ""
  tableOfContent = []
  for line in htmlLines:
    if "<h1>" in line:
      match = re.match("(.*)>(.*?)(\|.*)?<", line)
      line = "<h1 id=" + match.group(2).replace(" ", "_") + ">" + match.group(2) + "</h1>"
      tableOfContent.append("1"+match.group(2))
    elif "<h2>" in line:
      match = re.match("(.*)>(.*?)(\|.*)?<", line)
      line = "<h2 id=" + match.group(2).replace(" ", "_") + ">" + match.group(2) + "</h2>"
      tableOfContent.append("2"+match.group(2))
    htmlOutput += line + "\n"
  
  ## Insert the table of content
  htmlLines = htmlOutput.split("\n")
  htmlOutput = ""
  for line in htmlLines:
    if "TableOfContents" in line:
      sub = False
      table = '<table style="float:right; font-size: 0.9em; width:40%; background:#F1F1ED; margin: 0 0 1em 1em;"><tr><td>'
      table += '<p class="table-of-contents-heading">Contents<ol>\n'
      
      for item in tableOfContent:
        if item[:1] == "1":
          if sub == True:
            table += "</ol>\n"
            sub = False
          table += '<li><a href="#' + item[1:].replace(" ", "_") + '">' + item[1:] + "</li>\n"
        elif item[:1] == "2":
          if sub == False:
            table += "<ol>\n"
            sub = True
          table += '<li><a href="#' + item[1:].replace(" ", "_") + '">' + item[1:] + "</li>\n"
      table += "</ol>\n"
      table += "</td></tr></table>"
      line = table
    htmlOutput += line + "\n"

  header = open("header.html").read()
  footer = open("footer.html").read()

  output = open(outputDir+"/"+wikiPage+".html", "w")
  output.write(header + htmlOutput + footer)
  output.close()
  
command = "rsync -avz "+outputDir+"/Kubuntu/ kubuntu/"
subprocess.call(command, shell=True)
subprocess.call("rm -r "+outputDir, shell=True)
