#!/bin/sh
### BEGIN INIT INFO
# Provides:          kumofs
# Required-Start:    $network $local_fs $remote_fs
# Required-Stop:     $remote_fs
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: simple and fast distributed key-value store
### END INIT INFO

# Author: Taku YASUI <tach@debian.org>

# PATH should only include /usr/* if it runs after the mountnfs.sh script
PATH=/sbin:/usr/sbin:/bin:/usr/bin
DESC=kumofs
NAME=kumofs
SCRIPTNAME=/etc/init.d/$NAME
RUNAS=$NAME
PIDDIR=/var/run/$NAME
LOGDIR=/var/log/$NAME

# daemons
KUMO_MANAGER=/usr/sbin/kumo-manager
KUMO_MANAGER_ARGS=''
RUN_KUMO_MANAGER='no'
KUMO_SERVER=/usr/sbin/kumo-server
KUMO_SERVER_ARGS=''
RUN_KUMO_SERVER='no'
KUMO_GATEWAY=/usr/sbin/kumo-gateway
KUMO_GATEWAY_ARGS=''
RUN_KUMO_GATEWAY='no'

# Exit if the package is not installed
[ -x $KUMO_MANAGER ] || exit 0
[ -x $KUMO_SERVER ] || exit 0
[ -x $KUMO_GATEWAY ] || exit 0

# Read configuration variable file if it is present
test -r /etc/default/$NAME && . /etc/default/$NAME

# Load the VERBOSE setting and other rcS variables
. /lib/init/vars.sh

# Define LSB log_* functions.
# Depend on lsb-base (>= 3.0-6) to ensure that this file is present.
. /lib/lsb/init-functions

mkdir -p $PIDDIR
chown -R kumofs:kumofs $PIDDIR

#
# Function that starts the daemon/service
#
do_start()
{
	# Return
	#   0 if daemon has been started
	#   1 if daemon was already running
	#   2 if daemon could not be started

	# kumo-manager
	if [ "$RUN_KUMO_MANAGER" = "yes" ]; then
		[ "$VERBOSE" != no ] && log_progress_msg "kumo-manager"
		PIDFILE=$PIDDIR/`basename $KUMO_MANAGER`.pid
		LOGFILE=$LOGDIR/`basename $KUMO_MANAGER`.log
		start-stop-daemon --start --quiet --pidfile $PIDFILE --exec $KUMO_MANAGER --test > /dev/null \
			|| return 1
		start-stop-daemon --start --quiet --pidfile $PIDFILE --exec $KUMO_MANAGER --chuid $RUNAS --background -- \
			$KUMO_MANAGER_ARGS -d $PIDFILE -o $LOGFILE \
			|| return 2
	fi

	# kumo-server
	if [ "$RUN_KUMO_SERVER" = "yes" ]; then
		[ "$VERBOSE" != no ] && log_progress_msg "kumo-server"
		PIDFILE=$PIDDIR/`basename $KUMO_SERVER`.pid
		LOGFILE=$LOGDIR/`basename $KUMO_SERVER`.log
		start-stop-daemon --start --quiet --pidfile $PIDFILE --exec $KUMO_SERVER --test > /dev/null \
			|| return 1
		start-stop-daemon --start --quiet --pidfile $PIDFILE --exec $KUMO_SERVER --chuid $RUNAS --background -- \
			$KUMO_SERVER_ARGS -d $PIDFILE -o $LOGFILE \
			|| return 2
	fi

	# kumo-gateway
	if [ "$RUN_KUMO_GATEWAY" = "yes" ]; then
		[ "$VERBOSE" != no ] && log_progress_msg "kumo-manager"
		PIDFILE=$PIDDIR/`basename $KUMO_GATEWAY`.pid
		LOGFILE=$LOGDIR/`basename $KUMO_GATEWAY`.log
		start-stop-daemon --start --quiet --pidfile $PIDFILE --exec $KUMO_GATEWAY --test > /dev/null \
			|| return 1
		start-stop-daemon --start --quiet --pidfile $PIDFILE --exec $KUMO_GATEWAY --chuid $RUNAS --background -- \
			$KUMO_GATEWAY_ARGS -d $PIDFILE -o $LOGFILE \
			|| return 2
	fi
}

#
# Function that stops the daemon/service
#
do_stop()
{
	# Return
	#   0 if daemon has been stopped
	#   1 if daemon was already stopped
	#   2 if daemon could not be stopped
	#   other if a failure occurred

	for DAEMON in $KUMO_GATEWAY $KUMO_SERVER $KUMO_MANAGER; do
		PIDFILE=$PIDDIR/`basename $DAEMON`.pid
		NAME=`basename $DAEMON`
		[ "$VERBOSE" != no ] && log_progress_msg $NAME
		start-stop-daemon --stop --quiet --retry=TERM/30/KILL/5 --pidfile $PIDFILE --name $NAME
		RETVAL="$?"
		[ "$RETVAL" = 2 ] && return 2
		# Wait for children to finish too if this is a daemon that forks
		# and if the daemon is only ever run from this initscript.
		# If the above conditions are not satisfied then add some other code
		# that waits for the process to drop all resources that could be
		# needed by services started subsequently.  A last resort is to
		# sleep for some time.
		start-stop-daemon --stop --quiet --oknodo --retry=0/30/KILL/5 --exec $DAEMON
		[ "$?" = 2 ] && return 2
		# Many daemons don't delete their pidfiles when they exit.
		rm -f $PIDFILE
	done

	return "$RETVAL"
}

#
# Function that sends a SIGHUP to the daemon/service
#
do_reload() {
	#
	# If the daemon can reload its configuration without
	# restarting (for example, when it is sent a SIGHUP),
	# then implement that here.
	#
	#start-stop-daemon --stop --signal 1 --quiet --pidfile $PIDFILE --name $NAME
	#return 0
	:
}

case "$1" in
  start)
    [ "$VERBOSE" != no ] && log_daemon_msg "Starting $DESC"
    do_start
    case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
  ;;
  stop)
	[ "$VERBOSE" != no ] && log_daemon_msg "Stopping $DESC"
	do_stop
	case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
  status)
       status_of_proc "$DAEMON" "$NAME" && exit 0 || exit $?
       ;;
  #reload|force-reload)
	#
	# If do_reload() is not implemented then leave this commented out
	# and leave 'force-reload' as an alias for 'restart'.
	#
	#log_daemon_msg "Reloading $DESC" "$NAME"
	#do_reload
	#log_end_msg $?
	#;;
  restart|force-reload)
	#
	# If the "reload" option is implemented then remove the
	# 'force-reload' alias
	#
	log_daemon_msg "Restarting $DESC" "$NAME"
	do_stop
	case "$?" in
	  0|1)
		do_start
		case "$?" in
			0) log_end_msg 0 ;;
			1) log_end_msg 1 ;; # Old process is still running
			*) log_end_msg 1 ;; # Failed to start
		esac
		;;
	  *)
	  	# Failed to stop
		log_end_msg 1
		;;
	esac
	;;
  *)
	#echo "Usage: $SCRIPTNAME {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $SCRIPTNAME {start|stop|status|restart|force-reload}" >&2
	exit 3
	;;
esac

exit 0

# vim: ts=4 sw=4 ft=sh:
