using System;
using GtkExtra;

namespace Kurush
{

public class DetailsReport
{

    public DetailsReport (Data.Base dataBase, Data.Account account,
                          DateTime beginningDate, DateTime endingDate)
    {
        Report report = new Report (Kurush.PrConfig, 6, 8.0);

        report.ShowColumnTitles = true;
        report.Columns[0].Title = "Date";
        report.Columns[1].Title = "Account";
        report.Columns[2].Title = "Description";
        report.Columns[3].Title = "Debit";
        report.Columns[4].Title = "Credit";
        report.Columns[5].Title = "Balance";

        report.Columns[0].Width = 1.7;
        report.Columns[1].Width = 3.5;
        report.Columns[3].Width = 2.5;
        report.Columns[3].Align = Report.Alignment.Right;
        report.Columns[4].Width = 2.5;
        report.Columns[4].Align = Report.Alignment.Right;
        report.Columns[5].Width = 2.5;
        report.Columns[5].Align = Report.Alignment.Right;

        report.HeaderUser = dataBase.Title;
        report.HeaderTitle = account.Name;
        report.HeaderDate = Format.Value (beginningDate) + " ~ " +
                            Format.Value (endingDate);

        report.Open ();

        Data.Entry balEntry = dataBase.GetLastEntry (account, beginningDate.AddDays (-1));
        if (balEntry != null)
        {
            report.Add ("", "", "Previous Total",
                        Format.Value (balEntry.DebitBalance),
                        Format.Value (balEntry.CreditBalance),
                        Format.Value (dataBase.EntryBalance (account, balEntry)));
            report.AddSpace (1);
        }

        Data.Entry begEntry = dataBase.GetFirstEntry (account, beginningDate);
        Data.Entry endEntry = dataBase.GetLastEntry (account, endingDate);

        if (begEntry == null || endEntry == null)
        {
            report.AddSpace (1);
            report.Close ();
            report.Print ();
            return;
        }

        for (int i = begEntry.Pos; i <= endEntry.Pos; i ++)
        {
            Data.Entry entry = account.Entries[i] as Data.Entry;
            Data.Account toAccount = dataBase.LookupAccount (entry.AccountRef);

            report.Add (Format.Value (entry.Date), toAccount.Name,
                        entry.Description,
                        Format.Value (entry.Debit), Format.Value (entry.Credit),
                        Format.Value (dataBase.EntryBalance (account, entry)));
        }
        report.AddSpace (1);

        report.Add ("TOTAL", "", "",
                    Format.Value (endEntry.DebitBalance), Format.Value (endEntry.CreditBalance),
                    Format.Value (dataBase.EntryBalance (account, endEntry)));

        report.Close ();
        report.Print ();
    }


}

}
