using System;
using System.Collections;
using Gtk;


namespace Kurush
{

public class FrameManager : VBox
{
    static GLib.GType gtype = GLib.GType.Invalid;
    public static new GLib.GType GType {
        get
        {
            if (gtype == GLib.GType.Invalid)
                gtype = RegisterGType (typeof (FrameManager));
            return gtype;
        }
    }

    public Actions Actions
    {
        get
        {
            return actions;
        }
    }

    public Frame CurrentFrame
    {
        get
        {
            return currentFrame;
        }
    }


    private ArrayList frames = new ArrayList ();
    private Frame currentFrame = null;
    private Actions actions;
    private MenuItem goSeperator;
    private Menu menu;
    private ArrayList history = new ArrayList ();
    private int historyPos = -1;
    private int menuCount = 0;

    public Window AccountsPopup;
    public SummaryView AccountsView;
    public Window DatePopup;
    public Calendar DateView;

    public Data.Base DataBase;

    public FrameManager (Data.Base dataBase, Actions actions, Menu menu)
            : base (GType)
    {
        this.DataBase = dataBase;
        this.actions = actions;
        this.menu = menu;
        this.goSeperator = new SeparatorMenuItem ();
        menu.Append(goSeperator);
        actions.GoBack.Enabled = false;
        actions.GoForward.Enabled = false;

        DatePopup = new Window (WindowType.Popup);
        DateView = new Calendar ();
        DateView.DisplayOptions = CalendarDisplayOptions.ShowHeading |
                                  CalendarDisplayOptions.ShowDayNames |
                                  CalendarDisplayOptions.WeekStartMonday;
        DateView.Show ();
        DatePopup.Add (DateView);
    }

    ~FrameManager ()
    {
        AccountsPopup.Dispose ();
        DatePopup.Dispose ();
    }

    public bool Activate (Type frameType, object key)
    {
        bool success = false;

        foreach (Frame frame in frames)
        {
            if ( frame.GetType () == frameType )
            {
                if (frame.Key == key)
                {
                    success = true;
                    Go (frame);
                    break;
                }
            }
        }

        return success;
    }

    public bool Contains (Frame frame)
    {
        if (frame == null)
            return false;

        return frames.Contains (frame);
    }

    public void Go (Frame frame)
    {
        if (currentFrame == frame)
            return;

        if (!frames.Contains (frame))
        {
            frames.Add (frame);

            if (frame.MenuVisible)
            {
                menuCount++;
                menu.Append (frame.MenuItem);

                if (menuCount > 0)
                    goSeperator.Visible = true;
            }
        }

        if (!history.Contains (frame))
        {
            historyPos++;
            history.Insert (historyPos, frame);
            /*
            if (historyPos < history.Count -1 )
                history.RemoveRange (historyPos + 1,
                                     history.Count - historyPos - 1);
            */
        }
        else
            historyPos = history.IndexOf (frame);

        actions.GoBack.Enabled = historyPos > 0;
        actions.GoForward.Enabled = historyPos < history.Count - 1;

        if (currentFrame != null)
        {
            currentFrame.Content.Hide ();
            this.Remove (currentFrame.Content);
        }

        currentFrame = frame;
        this.PackStart (currentFrame.Content, true, true, 0);
        currentFrame.Content.Show ();

        frame.UpdateActions (actions);

        if (frame.DefaultWidget != null)
            frame.DefaultWidget.HasFocus = true;
    }

    public void Close (Frame frame)
    {
        if (frames.Contains (frame))
        {
            history.Remove (frame);
            Back ();

            if (frame.MenuVisible)
            {
                menuCount--;
                if (menuCount == 0)
                    goSeperator.Visible = false;

            }

            frames.Remove (frame);
        }
    }

    public void Back ()
    {
        if (historyPos > 0)
        {
            historyPos--;
            Go ( history [historyPos] as Frame);
        }
    }

    public void Forward ()
    {
        if (historyPos < history.Count - 1)
        {
            historyPos++;
            Go ( history [historyPos] as Frame);
        }
    }

}

}
