using System;
using Gtk;
using GtkExtra;

namespace GtkExtra
{

public class ManagedEntry
{
    private Entry entry;
    private IFormattable val = null;
    private TextDirection direction;

    public IFormattable Value
    {
        get
        {
            return this.val;
        }
        set
        {
            this.val = value;
            FormatEntry ();
        }
    }

    public bool HasFocus
    {
        get
        {
            return entry.HasFocus;
        }
        set
        {
            entry.HasFocus = value;
        }
    }

    public ManagedEntry (Entry entry, IFormattable value)
    {
        this.entry = entry;
        this.val = value;

        if (Entry.DefaultDirection == TextDirection.Rtl)
            this.direction = TextDirection.Ltr;
        else
            this.direction = TextDirection.Rtl;

        FormatEntry ();

        entry.FocusInEvent += new FocusInEventHandler (EntryFocusInEvent);
        entry.FocusOutEvent += new FocusOutEventHandler (EntryFocusOutEvent);
        Format.Info.Changed += new EventHandler (FormatChanged);
    }

    private void FormatChanged (object obj, EventArgs args)
    {
        FormatEntry ();
    }

    private void FormatEntry ()
    {
        entry.Text = Format.Value (val);

        if (!(val is DateTime))
            entry.Direction = direction;
    }

    private void EntryFocusInEvent (object o, FocusInEventArgs args)
    {
        if (! (val is DateTime))
        {
            entry.Direction = Entry.DefaultDirection;
            entry.Text =  val.ToString ();
        }
    }

    private void EntryFocusOutEvent (object o, FocusOutEventArgs args)
    {
        if (entry.Text != "")
        {
            try
            {
                if (val is DateTime)
                    val = DateTime.Parse (entry.Text, Format.Info.DateProvider);
                else if (val is decimal)
                    val = decimal.Parse (entry.Text, Format.Info.NumberProvider);
                else if (val is int)
                    val = int.Parse (entry.Text, Format.Info.NumberProvider);
            }
            catch (Exception e)
            {
            }
        }

        FormatEntry ();
    }

}



}
