using System;
using System.Threading;


namespace Kurush
{

public delegate void LoaderHandler (string filename, Data.Base dataBase);

public class LoaderThread
{
    private string filename;
    private LoaderHandler finishedHandler;
    private Data.Base dataBase;
    private Thread  thread;

    public LoaderThread (string filename, LoaderHandler finishedHandler)
    {
        lock (this)
        {
            this.filename = (string) filename.Clone ();
            this.finishedHandler = finishedHandler;
            thread = new Thread (new ThreadStart (ThreadMain));
            thread.Start ();
        }
    }

    public bool Stop ()
    {
        bool success = false;

        if (Monitor.TryEnter (this))
            Monitor.Exit (this);
        else
        {
            success = true;
            thread.Abort ();
            thread.Join ();
        }

        return success;
    }


    private void ThreadMain ()
    {
        lock (this)
        {
            try
            {
                try
                {
                    dataBase = new Data.Base (filename);
                }
                catch (Exception e)
                {
                    dataBase = null;
                }

                finishedHandler (filename, dataBase);

            }
            catch (ThreadAbortException e)
            {
                System.Diagnostics.Debug.WriteLine ("Loader thread aborted");
            }

        }
    }

}

}
