using System;
using Gtk;
using Glade;
using GtkExtra;

namespace Kurush
{

public class PropertiesDialog : TopLevel
{
    [Glade.Widget] private Entry titleEntry;
    [Glade.Widget] private Calendar fromCalendar;

    private Data.Base dataBase;

    public PropertiesDialog (Window parent, Data.Base dataBase)
            : base ("propertiesDialog", parent)
    {
        this.dataBase = dataBase;

        fromCalendar.SelectMonth ((uint) dataBase.ReportStart.Month - 1,
                                  (uint) dataBase.ReportStart.Year);
        fromCalendar.SelectDay ((uint) dataBase.ReportStart.Day);

        titleEntry.Text = dataBase.Title;
    }

    protected override void SelfResponse (object obj, ResponseArgs args)
    {
        if (args.ResponseId == (int) ResponseType.Ok)
        {
            dataBase.Title = titleEntry.Text;
            dataBase.ReportStart = fromCalendar.GetDate ();
            dataBase.Modified = true;
        }

        Self.Destroy ();
    }

}

}
