using System;
using System.Collections;
using System.IO;
using System.IO.IsolatedStorage;
using System.Xml;
using System.Xml.Serialization;

namespace Kurush
{


public class SettingKeys
{
    public int Width = 550;
    public int Height = 450;
    public bool Maximized = false;
    public bool Toolbar = true;
    public bool Statusbar = true;
    public bool TransferForm = true;
    public GtkExtra.FormatInfo FormatInfo = new GtkExtra.FormatInfo ();
    [XmlArrayItem(Type=typeof(string))]
    public ArrayList OpenRecentHistory = new ArrayList ();
}

public class Settings
{
    public SettingKeys Keys = new SettingKeys ();
    public string filename;

    public Settings (string filename)
    {
        this.filename = filename;

        try
        {
            IsolatedStorageFile isf =
                IsolatedStorageFile.GetUserStoreForAssembly();

            IsolatedStorageFileStream isfs =
                new IsolatedStorageFileStream(filename,
                                              FileMode.Open,
                                              FileAccess.Read,
                                              isf);

            XmlSerializer ser = new XmlSerializer(typeof(SettingKeys));

            XmlTextReader reader = new XmlTextReader(isfs);
            reader.XmlResolver = null;

            Keys = (SettingKeys) ser.Deserialize(reader);

            isfs.Close();
        }
        catch (Exception ex)
        {
            System.Diagnostics.Debug.WriteLine (ex.Message);
        }

    }

    public void Save ()
    {
        try
        {
            IsolatedStorageFile isf =
                IsolatedStorageFile.GetUserStoreForAssembly();

            IsolatedStorageFileStream isfs =
                new IsolatedStorageFileStream(filename,
                                              FileMode.Create,
                                              FileAccess.Write,
                                              isf);

            XmlSerializer ser = new XmlSerializer(typeof(SettingKeys));

            XmlTextWriter writer = new XmlTextWriter(isfs,
                                   System.Text.Encoding.UTF8);
            writer.Formatting = Formatting.Indented;

            ser.Serialize(writer, Keys);

            isfs.Close();
        }
        catch (Exception ex)
        {
            System.Diagnostics.Debug.WriteLine (ex.Message);
        }

    }


}


}
