using System;
using System.Collections;
using Gtk;

namespace Kurush
{


public class Action
{
    private ArrayList widgets = new ArrayList ();

    public Action (params Widget[] widgets)
    {
        foreach (Widget widget in widgets)
        {
            this.widgets.Add (widget);
            widget.Sensitive = enabled;
        }
    }

    private bool enabled = false;

    public bool Enabled
    {
        get
        {
            return enabled;
        }
        set
        {
            foreach (Widget widget in this.widgets)
            {
                widget.Sensitive = value;
            }

            enabled = value;
        }
    }
}

public delegate void TransferFormHandler (bool active, bool sensitive);

public class Actions
{
    public Action LoadContext;

    public Action FilePrint;
    public Action EditDetails;
    public Action EditProperties;
    public Action EditAdd;
    public Action EditRemove;
    public Action EditMove;
    public Action ViewExpandCollapse;

    public Action EditUndo;
    public Action EditRedo;
    public Action GoBack;
    public Action GoForward;


    public event TransferFormHandler TransferFormChanged;

    private bool transferFormActive = Kurush.Keys.TransferForm;
    private bool transferFormSensitive = true;

    public bool TransferFormActive
    {
        get
        {
            return transferFormActive;
        }
        set
        {
            transferFormActive = value;
            if (TransferFormChanged != null)
                TransferFormChanged (transferFormActive, transferFormSensitive);
        }
    }

    public bool TransferFormSensitive
    {
        get
        {
            return transferFormSensitive;
        }
        set
        {
            transferFormSensitive = value;
            if (TransferFormChanged != null)
                TransferFormChanged (transferFormActive, transferFormSensitive);
        }
    }

}


}
