using System;
using Gtk;
using GtkExtra;

namespace Kurush
{

public class DetailsView : TreeViewEx
{
    static GLib.GType gtype = GLib.GType.Invalid;
    public static new GLib.GType GType
    {
        get
        {
            if (gtype == GLib.GType.Invalid)
                gtype = RegisterGType (typeof (DetailsView));
            return gtype;
        }
    }

    private CellRendererText[] renderers =
        new CellRendererText[(int) DetailsNode.Columns.Count];
    private TreeViewColumn[] columns =
        new TreeViewColumn[(int) DetailsNode.Columns.Count];

    public DetailsView (NodeStore store) : base (store)
    {
        Selection.Mode = SelectionMode.Browse;
        RulesHint = true;

        for (int i = 0; i < (int) DetailsNode.Columns.Count; i++)
        {
            renderers[i] = new CellRendererText ();
            columns[i] = AppendColumn (((DetailsNode.Columns) i).ToString (),
                                       renderers[i],
                                       "text", i);
            columns[i].Resizable = true;
        }

        renderers[(int) DetailsNode.Columns.Credit].Xalign = 1.0F;
        columns[(int) DetailsNode.Columns.Credit].Alignment = 1.0F;

        renderers[(int) DetailsNode.Columns.Debit].Xalign = 1.0F;
        columns[(int) DetailsNode.Columns.Debit].Alignment = 1.0F;

        renderers[(int) DetailsNode.Columns.Balance].Xalign = 1.0F;
        renderers[(int) DetailsNode.Columns.Balance].Xpad = 4;
        columns[(int) DetailsNode.Columns.Balance].Alignment = 1.0F;

    }



}

}
