using System;
using System.Collections;
using Gtk;


namespace Kurush
{

public class Frame
{
    public FrameManager Owner;
    private Button closeButton;
    private Label titleLabel;
    private Toolbar titleBar;
    private VBox content;
    private MenuItem menuItem = null;
    private Label menuLabel;
    private int maxMenuTitle = 50;
    protected Widget defaultWidget = null;
    protected Glade.XML gxml;

    protected object key = null;

    private ArrayList dialogs = new ArrayList ();

    public void AddDialog (Widget dialog)
    {
        dialogs.Add (dialog);
    }

    public void RemoveDialog (Widget dialog)
    {
        dialogs.Remove (dialog);
    }

    public object Key
    {
        get
        {
            return key;
        }
    }

    public Widget DefaultWidget
    {
        get
        {
            return defaultWidget;
        }
    }

    public MenuItem MenuItem
    {
        get
        {
            return menuItem;
        }
    }

    public Widget Content
    {
        get
        {
            return content;
        }
    }

    public string Title
    {
        get
        {
            return titleLabel.Text;
        }
        set
        {
            int c = value.Length;

            if (c > maxMenuTitle)
                c = maxMenuTitle;

            menuLabel.Text = value.Substring (0, c);

            titleLabel.Markup = "<b>" + value + "</b>";
        }
    }

    public bool Closable
    {
        set
        {
            closeButton.Visible = value;
        }
    }

    public bool TitleVisible
    {
        set
        {
            titleBar.Visible = value;
        }
    }

    public bool MenuVisible
    {
        get
        {
            return  menuItem.Visible;
        }
        set
        {
            menuItem.Visible = value;
        }
    }

    protected Widget self;

    public Frame (FrameManager owner, string frameName)
    {
        this.Owner = owner;

        gxml =
            new Glade.XML (null, Kurush.Interface, frameName, null);
        this.self = gxml[frameName];
        gxml.Autoconnect (this);

        Gdk.Pixbuf pix = new Gdk.Pixbuf (null, "close.png");
        Image img = new Image ();
        img.Pixbuf = pix;
        img.Show ();
        closeButton = new Button ();
        closeButton.Show ();
        closeButton.Relief = ReliefStyle.None;
        closeButton.CanFocus = false;
        closeButton.Add (img);
        closeButton.Clicked += new EventHandler (CloseButtonClicked);

        titleLabel = new Label ();
        titleLabel.SetPadding (4, 4);
        titleLabel.Show ();

        titleBar = new Toolbar ();
        titleBar.Direction = TextDirection.Ltr;
        titleBar.AppendWidget (closeButton, "Close", "Close");
        titleBar.AppendWidget (titleLabel, null, null);
        titleBar.Show ();

        //Gdk.Color titleBarColor = new Gdk.Color (107, 130, 189);
        //titleBar.ModifyBg (StateType.Normal, titleBarColor);

        menuItem = new MenuItem ();
        menuLabel = new Label ();
        menuLabel.SetAlignment (0.0F, 0.5F);
        menuLabel.Show ();
        menuItem.Add (menuLabel);
        menuItem.Activated += new EventHandler (MenuItemActivated);
        menuItem.Show ();

        content = new VBox (false, 0);
        content.PackStart (titleBar, false, false, 0);
        content.PackStart (self, true, true, 0);
        content.Sink ();
    }

    ~Frame ()
    {
        content.Dispose ();
    }

    public virtual void UpdateActions (Actions actions)
    {

    }

    private void CloseButtonClicked (object o, EventArgs args)
    {
        Close ();
    }

    private void MenuItemActivated (object o, EventArgs args)
    {
        Owner.Go (this);
    }


    public virtual void Close ()
    {
        foreach (Widget dialog in dialogs)
        {
            dialog.Destroy ();
        }

        Owner.Close (this);
        menuItem.Destroy ();
    }

    public virtual void Add ()
    {
    }

    public virtual void Remove ()
    {
    }

    public virtual void Details ()
    {
    }

    public virtual void Properties ()
    {
    }

    public virtual void ExpandAll ()
    {
    }

    public virtual void CollapseAll ()
    {
    }

    public virtual void PrintReport ()
    {
    }

    public virtual void MoveUp ()
    {
    }

    public virtual void MoveDown ()
    {
    }

}

}
