using System;
using Gtk;

namespace GtkExtra
{

public class DecimalEntry : ManagedEntry
{
    private decimal val;

    public decimal Value
    {
        get
        {
            return this.val;
        }
        set
        {
            this.val = value;
            Update ();
        }
    }

    public DecimalEntry (Entry entry) : base (entry, true)
    {
    }

    protected override void FormatEntry ()
    {
        entry.Text = Format.Value (val);
    }

    protected override void UnFormatEntry ()
    {
        entry.Text =  val.ToString ();
    }

    protected override void ParseValue ()
    {
        val = decimal.Parse (entry.Text, Format.Info.NumberProvider);
    }

}

}
