using System;
using System.Collections;
using Gtk;

namespace GtkExtra
{

public delegate void OpenRecentActivateHandler (string filename);

public class OpenRecent
{
    private ArrayList parents = new ArrayList ();
    private ArrayList history;
    private int maxHistory;

    public event OpenRecentActivateHandler Activated;

    public string LastFile
    {
        get
        {
            if (history.Count == 0)
                return null;

            return history[history.Count - 1] as string;
        }
    }

    public OpenRecent (ArrayList history, int maxHistory)
    {
        this.history = history;
        this.maxHistory = maxHistory;
    }

    public void Add (string filename)
    {
        if (filename == null)
            return;

        if (history.Count > maxHistory)
            history.RemoveRange (0, history.Count - maxHistory);

        if (history.Contains (filename))
            Remove (filename);

        history.Add (filename);

        foreach (MenuItem parent in parents)
        {
            Menu menu = parent.Submenu as Menu;
            MenuItem item = NewMenuItem (filename);
            menu.Prepend (item);
            parent.Sensitive = true;
        }
    }


    public void Remove (string filename)
    {
        history.Remove (filename);

        foreach (MenuItem parent in parents)
        {
            parent.Sensitive = history.Count > 0;
            Menu menu = parent.Submenu as Menu;

            Gtk.Widget[] items = menu.Children;
            foreach (MenuItem item in items)
            {
                string name = item.Data["filename"] as string;
                if (name == filename)
                {
                    item.Destroy ();
                    break;
                }
            }
        }

    }

    private MenuItem NewMenuItem (string filename)
    {
        MenuItem item = new MenuItem (
                            System.IO.Path.GetFileName (filename));
        item.Show ();
        item.Activated += new EventHandler (MenuItemActivated);
        item.Data.Add ("filename", filename);

        return item;
    }

    public void AddClient (MenuItem parent)
    {
        parents.Add (parent);
        parent.Sensitive = history.Count > 0;

        Menu menu = new Menu ();
        menu.Show ();

        foreach (string filename in history)
        {
            MenuItem item = NewMenuItem (filename);
            menu.Prepend (item);
        }

        parent.Submenu = menu;
    }

    public void RemoveClient (MenuItem parent)
    {
        parents.Remove (parent);
    }

    private void MenuItemActivated (object obj, EventArgs args)
    {
        if (Activated != null)
        {
            MenuItem item = obj as MenuItem;
            string filename = item.Data["filename"] as string;
            Activated (filename);
        }
    }

}

}
