using System;
using Gtk;
using Gnome;

namespace Kurush
{

public class PrintSetupDialog : Dialog
{
    static GLib.GType gtype = GLib.GType.Invalid;
    public static new GLib.GType GType
    {
        get
        {
            if (gtype == GLib.GType.Invalid)
                gtype = RegisterGType (typeof (PrintSetupDialog));
            return gtype;
        }
    }

    PrinterSelector printerSelector;

    public PrintSetupDialog (PrintConfig config) : base (GType)
    {
        this.Title = "Print Setup";
        this.HasSeparator = false;
        this.Resizable = false;
        this.DestroyWithParent = true;
        this.AddButton (Gtk.Stock.Close, (int) ResponseType.Close);

        VBox vbox = new VBox (false, 4);
        vbox.Show ();
        vbox.BorderWidth = 5;
        this.VBox.PackStart (vbox, true, true, 0);

        printerSelector = new PrinterSelector (config);
        printerSelector.Show ();
        vbox.PackStart (printerSelector, true, true, 0);
    }

}

}
