using System;
using Gtk;

namespace GtkExtra
{


public class WidgetEntry : HBox
{
    static GLib.GType gtype = GLib.GType.Invalid;
    public static new GLib.GType GType
    {
        get
        {
            if (gtype == GLib.GType.Invalid)
                gtype = RegisterGType (typeof (WidgetEntry));
            return gtype;
        }
    }

    private Entry entry;
    private ToggleButton button;
    private Window popup;
    private Gdk.Screen screen;
    public object Content = null;

    public event EventHandler PopDown = null;
    public event EventHandler PopUp = null;

    public Entry Entry
    {
        get
        {
            return entry;
        }
    }

    public string Text
    {
        get
        {
            return entry.Text;
        }
        set
        {
            entry.Text = value;
        }
    }

    public bool Active
    {
        get
        {
            return button.Active;
        }
        set
        {
            button.Active = value;
        }
    }

    public int Width
    {
        set
        {
            entry.WidthChars = value;
        }
    }

    public bool AutoSize = false;

    private int popupWidth;
    private int popupHeight;
    private int buttonWidth;
    private Gdk.TimeCoord gdkTime;

    private WidgetEventHandler popupWidgetEventHandler;

    public WidgetEntry (Window popup) : base (GType)
    {
        this.popup = popup;

        popup.AllowGrow = true;
        popup.AllowShrink = true;

        popupWidgetEventHandler = new WidgetEventHandler (PopupWidgetEvent);

        gdkTime = Gdk.TimeCoord.Zero;

        screen = Gdk.Screen.Default;
        entry = new Entry ();
        entry.Show ();

        Alignment alignment = new Alignment (0.5F, 0.5F, 0.0F, 0.0F);
        alignment.Show ();
        button = new ToggleButton ();
        button.Show ();
        alignment.Add (button);
        Arrow arrow = new Arrow (ArrowType.Down, ShadowType.None);
        arrow.Show ();
        arrow.SetAlignment (0.5F, 0.5F);
        button.Add (arrow);

        this.PackStart (entry, true, true, 0);
        this.PackStart (alignment, false, false, 0);

        Requisition requisition = new Requisition ();
        //popup.SizeRequest (ref requisition);
        requisition = popup.SizeRequest ();
        popupWidth = requisition.Width;
        popupHeight = requisition.Height;

        entry.SizeRequested += new SizeRequestedHandler (EntrySizeRequested);
        entry.SizeAllocated += new SizeAllocatedHandler (EntrySizeAllocated);
        button.Toggled += new EventHandler (ButtonToggled);
    }

    private void EntrySizeRequested (object o, SizeRequestedArgs args)
    {
        buttonWidth = args.Requisition.Height;
        button.SetSizeRequest (buttonWidth, buttonWidth);
    }

    private void EntrySizeAllocated (object o, SizeAllocatedArgs args)
    {
        if (AutoSize)
        {
            popupHeight = screen.Height / 4;
            popupWidth = args.Allocation.Width + buttonWidth;
            popup.HeightRequest = popupHeight;
        }
    }

    private void PopupWidgetEvent (object o, WidgetEventArgs args)
    {
        if (args.Event.Type == Gdk.EventType.KeyPress)
        {
            Gdk.EventKey kev = new Gdk.EventKey (args.Event.Handle);

            if ( kev.KeyValue == (uint) Gdk.Key.Escape)
                button.Active = false;
        }
        else if (args.Event.Type == Gdk.EventType.ButtonRelease)
        {

            Gdk.EventButton ev = new Gdk.EventButton (args.Event.Handle);

            int x,y;
            popup.GdkWindow.GetOrigin (out x, out y);

            if ( ev.XRoot < x || ev.XRoot > x + popupWidth ||
                    ev.YRoot < y || ev.YRoot > y + popupHeight )
            {
                button.Active = false;
            }
        }
    }

    private void ButtonToggled (object o, EventArgs args)
    {
        if (button.Active)
        {
            if (AutoSize)
            {
                popup.WidthRequest = popupWidth;
                popup.Resize (popupWidth, popupHeight);
            }

            int x,y;
            button.GdkWindow.GetOrigin (out x, out y);

            //x += button.Allocation.x + button.Allocation.width - popupWidth;
            //y += button.Allocation.y + button.Allocation.height;

            x += entry.Allocation.X;
            y += entry.Allocation.Y + entry.Allocation.Height;

            if (y + popupHeight > screen.Height)
                y -= popupHeight + button.Allocation.Height;

            if (x < 0)
                x = 0;

            if (x + popupWidth > screen.Width)
                x =  screen.Width - popupWidth;

            popup.Move (x, y);

            popup.Show ();
            entry.GrabFocus ();

            Grab.Add (popup);
            Gdk.Pointer.Grab (popup.GdkWindow, true,
                              Gdk.EventMask.ButtonPressMask |
                              Gdk.EventMask.ButtonReleaseMask |
                              Gdk.EventMask.PointerMotionMask,
                              null, null, gdkTime.Time);
            Gdk.Keyboard.Grab (popup.GdkWindow, true, gdkTime.Time);

            popup.WidgetEvent += popupWidgetEventHandler;
            if (PopUp != null)
                PopUp (this, new EventArgs ());
        }
        else
        {
            popup.WidgetEvent -= popupWidgetEventHandler;
            Grab.Remove (popup);
            popup.Hide ();
            if (PopDown != null)
                PopDown (this, new EventArgs ());
        }

    }
}




}
