using System;
using System.IO;
using System.Threading;

namespace Kurush
{

public delegate void SaverHandler (bool success);

public class SaverThread
{
    private Data.Base dataBase;
    private Data.Base original;
    private Thread  thread;
    private SaverHandler finishedHandler;
    public SaverHandler abortedHandler;

    public SaverThread (SaverHandler finishedHandler, SaverHandler abortedHandler)
    {
        this.finishedHandler = finishedHandler;
        this.abortedHandler = abortedHandler;
    }

    public bool Start (Data.Base dataBase)
    {
        bool success = false;

        if (Monitor.TryEnter (this))
        {
            success = true;
            this.dataBase = (Data.Base) dataBase.Clone ();
            this.original = dataBase;
            original.Modified = false;
            thread = new Thread (new ThreadStart (ThreadMain));
            thread.Start ();
            Monitor.Exit (this);
        }

        return success;
    }

    public bool Stop ()
    {
        bool success = false;

        if (Monitor.TryEnter (this))
            Monitor.Exit (this);
        else
        {
            success = true;
            thread.Abort ();
        }

        return success;
    }

    public bool Active
    {
        get
        {
            bool success = true;
            if (Monitor.TryEnter (this))
            {
                success = false;
                Monitor.Exit (this);
            }
            return success;
        }
    }


    private void ThreadMain ()
    {
        lock (this)
        {
            bool success = false;

            try
            {
                try
                {
                    dataBase.Save (dataBase.Filename + "~");
                    success = true;
                }
                catch (Exception e)
                {
                }
            }
            catch (ThreadAbortException e)
            {
                Gdk.Threads.Enter ();
                abortedHandler (success);
                Gdk.Threads.Leave ();

                Thread.ResetAbort ();
            }

            if (success)
            {
                try
                {
                    System.IO.File.Move (dataBase.Filename + "~",
                                         dataBase.Filename);

                    System.Diagnostics.Debug.WriteLine (dataBase.Filename +
                                                        " saved successfuly");
                }
                catch (Exception e)
                {
                    success = false;
                }
            }

            Gdk.Threads.Enter ();
            if (!success)
            {
                original.Modified = true;
                System.Diagnostics.Debug.WriteLine ("Error saving " +
                                                    dataBase.Filename);
            }
            finishedHandler (success);
            Gdk.Threads.Leave ();
        }
    }

}


}
