using System;
using Gtk;
using Glade;

namespace Kurush
{

public class TopLevel
{
    public Window Self;
    public event ResponseHandler Response;
    protected Glade.XML gxml;

    public TopLevel (string topLevel, Window parent)
    {
        gxml = new Glade.XML (null, Kurush.Interface, topLevel, null);
        gxml.Autoconnect (this);

        Self = gxml[topLevel] as Dialog;

        if (parent != null)
            Self.TransientFor = parent;

        if (Self is Dialog)
            (Self as Dialog).Response += new ResponseHandler (SelfResponse);
    }

    protected virtual void SelfResponse (object obj, ResponseArgs args)
    {
        if (Response != null)
            Response (this, args);
    }



}

}
