// =============================================================================
//
//      --- kvi_mdi_toolbar.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviMdiToolbar"

#include "kvi_app.h"
#include "kvi_defines.h"
#include "kvi_frame.h"
#include "kvi_locale.h"
#include "kvi_mdi_toolbar.h"

static const QString tb_tileHorAnodine("horizontal1.png");
static const QString tb_tileHorPragma("horizontal2.png");
static const QString tb_tileVerPragma("vertical.png");
static const QString tb_tileCascade("cascade.png");

/**
 * KviMdiToolBar
 */
KviMdiToolBar::KviMdiToolBar(KviFrame *parent)
	: KviToolBar("MdiToolBar", parent, parent, Qt::DockTop, false, "mdi_tool_bar")
{
	setPreferOwnIcons(true);

	insertButton(
		tb_tileHorPragma, 200, SIGNAL(clicked()), (QObject *) parent->m_pMdi, SLOT(tilePragmaHorizontal()), true,
		_i18n_("Pragma's Tile (Horizontal)"), _i18n_("Tile windows horizontally")
	);
	insertButton(
		tb_tileHorAnodine, 201, SIGNAL(clicked()), (QObject *) parent->m_pMdi, SLOT(tileAnodine()), true,
		_i18n_("Anodine's Tile (Horizontal)"), _i18n_("Tile windows horizontally")
	);
	insertButton(
		tb_tileVerPragma, 202, SIGNAL(clicked()), (QObject *) parent->m_pMdi, SLOT(tilePragmaVertical()), true,
		_i18n_("Pragma's Tile (Vertical)"), _i18n_("Tile windows vertically")
	);
	insertButton(
		tb_tileCascade, 203, SIGNAL(clicked()), (QObject *) parent->m_pMdi, SLOT(cascadeMaximized()), true,
		_i18n_("Cascade Maximized"), _i18n_("Tile windows maximized")
	);

	setHorizontalStretchable(false);
	setVerticalStretchable(false);

	setBackgroundMode(PaletteBackground);
}

/**
 * ~KviMdiToolBar
 */
KviMdiToolBar::~KviMdiToolBar()
{
	// Nothing here
}

#include "m_kvi_mdi_toolbar.moc"
