#ifndef _KVI_IRC_PROXY_H_INCLUDED_
#define _KVI_IRC_PROXY_H_INCLUDED_

// =============================================================================
//
//      --- kvi_irc_proxy.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>

#include "kvi_dns.h"
#include "kvi_string.h"

class KviConfig;

typedef struct
{
	KviStr         szHost;
	KviIpAddresses addresses;
	KviStr         szPassword;
	KviStr         szUsername;
	KviStr         szPort;
} KviIrcProxy;

class KviIrcProxyManager
{
public:
	KviIrcProxyManager();
	~KviIrcProxyManager();
private:
	QPtrList<KviIrcProxy> *m_pProxyList;
	KviIrcProxy        *m_pCurrentProxy;
public:
	void load(KviConfig *cfg);
	void save(KviConfig *cfg);
	void clear();
	void copyFrom(KviIrcProxyManager *m);
	KviIrcProxy *currentProxy();
	KviIrcProxy *getProxyByName(const char *szName);
	void updateProxyIp(const char *szName, KviIpAddresses list);
	bool setCurrentProxy(KviIrcProxy *prx);
	bool removeProxy(KviIrcProxy *prx);
	void appendProxy(KviIrcProxy *prx);
	QPtrList<KviIrcProxy> *proxyList();
};

#endif // _KVI_IRC_PROXY_H_INCLUDED_
