#ifndef _KVI_LOCALE_H_INCLUDED_
#define _KVI_LOCALE_H_INCLUDED_

// =============================================================================
//
//      --- kvi_locale.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_settings.h"

#ifdef _KVI_LOCALE_CPP_

	#ifdef COMPILE_LOCALE_STUFF
		#include <qtranslator.h>
		class QString;

		class KviTranslator : public QTranslator
		{
			Q_OBJECT
			public:
				KviTranslator(QObject *parent, const char *name);
				~KviTranslator();
			public:
				virtual QString find(const char *scope, const char *message) const;
		};
	#endif

#else // _KVI_LOCALE_CPP_

	class KviApplication;

	extern bool kvi_initLocale(KviApplication *app, const char *localeDir);
	extern void kvi_destroyLocale(KviApplication *app);
	extern char *kvi_getLocaleName();

	#ifdef COMPILE_LOCALE_STUFF
		#define __tr(__text__) kvi_translate(__text__)

		// This one returns the translated string text,
		// reading it from the current translation map.
		// If no map is available or the entry is not found,
		// it returns the string untranslated.
		extern const char *kvi_translate(const char *text);

#if 1 // TODO: Use proper gettext calls for that. Or something.
		// The below macros should disappear in the near future.
		#define _i18n_(__text__)                 kvi_translate(__text__)
		#define _i18n_translateNoText(__stuff__) kvi_translate(__stuff__)
		#define _i19n_(__text__)                 __text__
#endif
	#else
		#define __tr(__text__)                   __text__

		#define _i18n_(__text__)                 __text__
		#define _i18n_translateNoText(__stuff__) __stuff__
		#define _i19n_(__text__)                 __text__
	#endif // COMPILE_LOCALE_STUFF

#endif // _KVI_LOCALE_CPP_

#endif // _KVI_LOCALE_H_INCLUDED_
