// =============================================================================
//
//      --- kvi_options_dcc_chat.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsDccChat"

#include <qlayout.h>

#include "kvi_boolselector.h"
#include "kvi_locale.h"
#include "kvi_options_dcc_chat.h"
#include "kvi_options.h"

/*
	@quickhelp: KviOptionsDccChat
	@widget: DCC chat options
		Here you can set the options for the DCC chat connections.<br>
		You can choose to make KVIrc automatically accept all the incoming DCC Chat
		connections (otherwise you will be asked for the permission).<br>
		Please note that if you have disabled all the incoming DCC requests
		the DCC chat will NOT WORK.<br>
*/
KviOptionsDccChat::KviOptionsDccChat(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_DCCCHAT)
{
	QGridLayout *g = new QGridLayout(
		this, 3, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE
	);

	KviBoolSelector *b = new KviBoolSelector(this, __tr("Automatically accept"), &(g_pOptions->m_bAutoAcceptDccChat));
	g->addWidget(b, 0, 0);

	b = new KviBoolSelector(this, __tr("Create iconified"), &(g_pOptions->m_bCreateIconifiedDccChat));
	g->addWidget(b, 1, 0);

	// Trick
	QFrame *f = new QFrame(this);
	g->addWidget(f, 2, 0);
	g->setRowStretch(2, 1);
}

KviOptionsDccChat::~KviOptionsDccChat()
{
	// Nothing here
}

void KviOptionsDccChat::commitChanges()
{
	KviBoolSelector::commitAll(this);
}

#include "m_kvi_options_dcc_chat.moc"
