// =============================================================================
//
//      --- kvi_biff_mailbox.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Authors:
//       Krzysztof Godlewski    <kristoff@poczta.wprost.pl>
//       Szymon Stefanek        <stefanek@tin.it>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviBiffMailbox"

#include "kvi_biff_mailbox.h"
#include "kvi_biff_message.h"

KviBiffMailbox::KviBiffMailbox(const char *host, const char *user,
	const char *pass, unsigned int port, bool auto_check)
{
	m_hostname     = host;
	m_port         = port;
	m_username     = user;
	m_password     = pass;
	m_autoCheck    = auto_check;
	m_pMessageList = new QPtrList<KviBiffMessage>;
	m_pMessageList->setAutoDelete(true);
}

KviBiffMailbox::~KviBiffMailbox()
{
	delete m_pMessageList;
	m_pMessageList = 0;
}

char *KviBiffMailbox::hostname() const
{
	return m_hostname.ptr();
}

char *KviBiffMailbox::username() const
{
	return m_username.ptr();
}

char *KviBiffMailbox::password() const
{
	return m_password.ptr();
}

unsigned int KviBiffMailbox::port() const
{
	return m_port;
}

unsigned int KviBiffMailbox::messageCount()
{
	return m_pMessageList->count();
}

QPtrList<KviBiffMessage> *KviBiffMailbox::messageList()
{
	return m_pMessageList;
}

KviBiffMessage *const KviBiffMailbox::findMessageByUid(const char *uid) const
{
	for( KviBiffMessage *m = m_pMessageList->first(); m; m = m_pMessageList->next() ) {
	    if( kvi_strEqualCI(m->uid(), uid) ) return m;
	}
	return 0;
}

const bool KviBiffMailbox::autoCheck() const
{
	return m_autoCheck;
}
