// =============================================================================
//
//      --- kvi_biff_message.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Authors:
//       Krzysztof Godlewski    <kristoff@poczta.wprost.pl>
//       Szymon Stefanek        <stefanek@tin.it>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviBiffMessage"

#include "kvi_biff_message.h"

KviBiffMessage::KviBiffMessage(const char *from, const char *subject, const char *uid)
{
	m_from    = from;
	m_subject = subject;
	m_uid     = uid;
}

KviBiffMessage::~KviBiffMessage()
{
	// Nothing here
}

const char *const KviBiffMessage::from()    const      { return m_from.ptr();    }
const char *const KviBiffMessage::subject() const      { return m_subject.ptr(); }
const char *const KviBiffMessage::uid()     const      { return m_uid.ptr();     }
