#ifndef _KVI_STAT_CHAN_H_INCLUDED_
#define _KVI_STAT_CHAN_H_INCLUDED_

// =============================================================================
//
//        --- kvi_stat_chan.h ---
//
//   This is a plugin for KVIrc 2. It allows you to see
//   statistics of your IRC sessions - total words said etc.
//   More features are still to come.
//
//   (c) Krzysztof Godlewski <kristoff@poczta.wprost.pl>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_string.h"

class KviStatChan
{
public:
	KviStatChan(
	    const char *_name,
	    unsigned int _joins  = 1, unsigned int _words   = 0,
	    unsigned int _kicks  = 0, unsigned int _bans    = 0,
	    unsigned int _topics = 0, unsigned int _actions = 0
	);
	~KviStatChan();

	void addJoins  (int num = 1);
	void addWords  (int num = 1);
	void addKicks  (int num = 1);
	void addBans   (int num = 1);
	void addTopics (int num = 1);
	void addActions(int num = 1);

	const char *name()     const;
	unsigned int joins()   const;
	unsigned int words()   const;
	unsigned int bans()    const;
	unsigned int kicks()   const;
	unsigned int topics()  const;
	unsigned int actions() const;

private:
	KviStr       m_name;
	unsigned int m_joins;
	unsigned int m_words;
	unsigned int m_kicks;
	unsigned int m_bans;
	unsigned int m_topics;
	unsigned int m_actions;
};

#endif // _KVI_STAT_CHAN_H_INCLUDED_
