// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Andrea Parrella (anandrea@iname.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviUrlToolBar"

#ifdef QT_NO_ASCII_CAST
	#undef QT_NO_ASCII_CAST
#endif

#include "kvi_frame.h"
#include "kvi_locale.h"
#include "kvi_options.h"
#include "kvi_url.h"
#include "kvi_url_configdialog.h"
#include "kvi_url_dialog.h"
#include "kvi_url_toolbar.h"

static const QString g_iURL("url.png");
static const QString g_iURLConfig("urlconfig.png");

/**
 * KviUrlToolBar
 */
KviUrlToolBar::KviUrlToolBar(KviFrame *parent)
	: KviToolBar("KviUrlToolBar", parent, parent, Qt::DockTop, false, "url_tool_bar")
{
	m_configButton = 0;
	m_urlButton    = 1;
	m_pParent      = parent;

	insertButton(
		g_iURL, m_urlButton, SIGNAL(clicked()), this, SLOT(loadUrlListWindow()), true,
		__tr("URL List"), __tr("Load URL list window")
	);
	insertButton(
		g_iURLConfig, m_configButton, SIGNAL(clicked()), this, SLOT(loadConfigure()), true,
		__tr("Configuration"), __tr("Load configuration dialog")
	);

	setHorizontalStretchable(false);
	setVerticalStretchable(false);
	setBackgroundMode(PaletteBackground);
}

void KviUrlToolBar::loadUrlListWindow()
{
	KviUrlDlgList *tmpitem = findFrame(m_pParent);
	if( tmpitem->toolbar )
		tmpitem->toolbar->setButtonIcon(tmpitem->toolbar->m_urlButton, g_iURL);
	if( tmpitem->dlg )
		tmpitem->dlg->close();
	else
		urllist(m_pParent);
}

void KviUrlToolBar::loadConfigure()
{
	if( !g_pConfigDialog ) g_pConfigDialog = new KviUrlConfigDialog();
}

KviUrlToolBar::~KviUrlToolBar()
{
	KviUrlDlgList *tmpitem = findFrame(m_pParent);
	tmpitem->toolbar = 0;
}

#include "m_kvi_url_toolbar.moc"
