#ifndef _KVI_KVS_H_
#define _KVI_KVS_H_
//=============================================================================
//
//   File : kvi_kvs.h
//   Creation date : Wed 1 Oct 2003 01.37 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2003 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

// this header contains ALL the stuff that the user should see
#include "kvi_kvs_script.h"

namespace KviKvs
{
	void init(); // this never fails
	void done(); // this never fails

	void loadAliases(const QString &szFileName);
	void saveAliases(const QString &szFileName);
	void clearAliases();
	
	void loadPopups(const QString &szFileName);
	void savePopups(const QString &szFileName);
	void clearPopups();
	
	void loadAppEvents(const QString &szFileName);
	void saveAppEvents(const QString &szFileName);
	void clearAppEvents();
	
	void loadRawEvents(const QString &szFileName);
	void saveRawEvents(const QString &szFileName);
	void clearRawEvents();
};


#endif //!_KVI_KVS_H_
