//=============================================================================
//
//   File : kvi_kvs_array.cpp
//   Created on Tue 07 Oct 2003 01:07:31 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_array.h"

KviKvsArray::KviKvsArray()
{
	m_pDict = new QIntDict<KviKvsVariant>();
	m_pDict->setAutoDelete(true);
}

KviKvsArray::KviKvsArray(const KviKvsArray &a)
{
	m_pDict = new QIntDict<KviKvsVariant>();
	m_pDict->setAutoDelete(true);
	QIntDictIterator<KviKvsVariant> it(*m_pDict);
	while(it.current())
	{
		m_pDict->replace(it.currentKey(),new KviKvsVariant(*(it.current())));
		++it;
	}
}

KviKvsArray::~KviKvsArray()
{
	delete m_pDict;
}

unsigned int KviKvsArray::size() const
{
	QIntDictIterator<KviKvsVariant> it(*m_pDict);
	int iMax = 0;
	while(it.current())
	{
		if(it.currentKey() > iMax)iMax = it.currentKey();
		++it;
	}
	return iMax + 1;
}

void KviKvsArray::appendAsString(QString &szBuffer) const
{
	QIntDictIterator<KviKvsVariant> it(*m_pDict);
	bool bNeedComma = false;
	while(KviKvsVariant * s = it.current())
	{
		if(bNeedComma)szBuffer.append(',');
		else bNeedComma = true;
		s->appendAsString(szBuffer);
		++it;
	}
}

KviKvsVariant * KviKvsArray::get(int iIdx)
{
	KviKvsVariant * v = find(iIdx);
	if(v)return v;
	v = new KviKvsVariant();
	m_pDict->replace(iIdx,v);
	return v;
}

