//=============================================================================
//
//   File : kvi_kvs_treenode_scopeoperator.cpp
//   Created on Tue 07 Oct 2003 02:33:01 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_treenode_scopeoperator.h"

#include "kvi_qstring.h"

#include "kvi_kvs_variant.h"
#include "kvi_kvs_runtimecontext.h"

#include "kvi_locale.h"

KviKvsTreeNodeScopeOperator::KviKvsTreeNodeScopeOperator(const QChar * pLocation,KviKvsTreeNodeData * pObject,KviKvsTreeNodeData * pData)
: KviKvsTreeNodeData(pLocation)
{
	m_pObjectReference = pObject;
	m_pObjectReference->setParent(this);
	m_pRightSide = pData;
	m_pRightSide->setParent(this);
}

KviKvsTreeNodeScopeOperator::~KviKvsTreeNodeScopeOperator()
{
	delete m_pObjectReference;
	delete m_pRightSide;
}


void KviKvsTreeNodeScopeOperator::dump(const char * prefix)
{
	debug("%s ScopeOperator",prefix);
	QString tmp = prefix;
	tmp.append("  ");
	m_pObjectReference->dump(tmp.latin1());
	m_pRightSide->dump(tmp.latin1());
}

bool KviKvsTreeNodeScopeOperator::isReadOnly()
{
	return m_pRightSide->isReadOnly();
}

bool KviKvsTreeNodeScopeOperator::canEvaluateToObjectReference()
{
	return m_pRightSide->canEvaluateToObjectReference();
}

bool KviKvsTreeNodeScopeOperator::isFunctionCall()
{
	return m_pRightSide->isFunctionCall();
}

bool KviKvsTreeNodeScopeOperator::canEvaluateInObjectScope()
{
	return m_pRightSide->canEvaluateInObjectScope();
}

/*
bool KviKvsTreeNodeScopeOperator::canReleaseResult()
{
	return m_pRightSide->canReleaseResult();
}
*/

bool KviKvsTreeNodeScopeOperator::evaluateReadOnly(KviKvsRunTimeContext * c,KviKvsVariant * pBuffer)
{
//#warning "Scope operator evaluate() implementation is missing"
	return false;
}

KviKvsRWEvaluationResult * KviKvsTreeNodeScopeOperator::evaluateReadWrite(KviKvsRunTimeContext * c)
{
	return 0;
}

/*
bool KviKvsTreeNodeScopeOperator::evaluate(KviKvsRunTimeContext * c)
{

	if(!m_pObjectReference->evaluate(c))return false;

	KviKvsObject * o = KviKvsKernel::instance()->findObject(szId);
	if(!o)
	{
		c->error(this,__tr2qs("The left side of the scope operator didn't evaluate to a valid object reference"));
		return false;
	}

	c->pushScopeObject(o);
	if(!m_pRightSide->evaluate(c))return false;
	c->popScopeObject();

	return true;
}
	*/
