//=============================================================================
//
//   File : kvi_splash.cpp
//   Creation date : Wed Aug 8 2001 17:46:10 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__
#include "kvi_string.h"
#include "kvi_app.h"
#include "kvi_defaults.h"
#include "kvi_splash.h"
#include "kvi_locale.h"
#include "kvi_fileutils.h"

#include <qpixmap.h>
#include <qlayout.h>

KviSplashScreen::KviSplashScreen()
#if QT_VERSION >= 300
: QFrame(0,0,WStyle_Customize | WStyle_NoBorder | WStyle_Tool | WStyle_StaysOnTop)
#else
: QFrame(0,0,WStyle_Customize | WStyle_NoBorderEx | WStyle_Tool | WStyle_StaysOnTop)
#endif
{
#ifdef COMPILE_SPLASH_SCREEN

	setFrameStyle(QFrame::Panel|QFrame::Raised);

	QGridLayout * g = new QGridLayout(this,5,1,3,2);

	KviStr szPix;
	QPixmap * pix = 0;

	// check for the current theme splash screen pointer
	QString szPointerFile;
	g_pApp->getLocalKvircDirectory(szPointerFile,KviApp::Themes,"current-splash");
	if(KviFileUtils::fileExists(szPointerFile))
	{
		QString szBuf;
		KviFileUtils::readFile(szPointerFile,szBuf);
		if(!szBuf.isEmpty())
		{
			g_pApp->getLocalKvircDirectory(szPix,KviApp::Themes,szBuf.latin1());
			szPix.ensureLastCharIs(KVI_PATH_SEPARATOR_CHAR);
			szPix.append("kvi_splash.png");
			pix = new QPixmap(szPix.ptr());
			if(pix->isNull())
			{
				// no way..
				delete pix;
				pix = 0;
			} // else we have a themed splash screen
		}
	}

	if(!pix)
	{
		if(g_pApp->findImage(szPix,"kvi_splash.png"))
		{
			pix = new QPixmap(szPix.ptr());
		} else {
			// dummy image
			pix = new QPixmap(300,200);
		}
	}
	
	m_pPixLabel = new QLabel("...",this);
	m_pPixLabel->setMinimumSize(pix->size());
	m_pPixLabel->setMaximumSize(pix->size());
	m_pPixLabel->setBackgroundColor(black);
	m_pPixLabel->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	m_pPixLabel->setPixmap(*pix);
	m_pPixLabel->setAlignment(AlignCenter);

	m_pPixLabel->installEventFilter(this);

	g->addWidget(m_pPixLabel,0,0);

	KviStr szText(KviStr::Format,"<center><nobr>%s</nobr></center>",KVI_SPLASH_SCREEN_TEXT);

	QLabel * l = new QLabel(szText.ptr(),this);
	QFont f = QFont();
	f.setPointSize(10);
	l->setFont(f);
	//l->setAlignment(AlignCenter);
	l->setMaximumWidth(pix->width());
	g->addWidget(l,1,0);

	QFrame * r = new QFrame(this);
	r->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	r->setMinimumHeight(r->frameWidth() * 2);
	g->addWidget(r,2,0);

	m_pLabel = new QLabel(__tr2qs("Initiating startup sequence..."),this);
	m_pLabel->setFont(f);
	m_pLabel->setAlignment(AlignCenter);
	g->addWidget(m_pLabel,3,0);

	m_pProgress = new QProgressBar(100,this);

	g->addWidget(m_pProgress,4,0);

	g->setResizeMode(QLayout::Fixed);

	delete pix;

	m_pTimer = new QTimer(this);
	connect(m_pTimer,SIGNAL(timeout()),this,SLOT(suicide()));
#endif
}

KviSplashScreen::~KviSplashScreen()
{
#ifdef COMPILE_SPLASH_SCREEN
	delete m_pTimer;
#endif
}

#ifdef COMPILE_SPLASH_SCREEN
	
	bool KviSplashScreen::eventFilter(QObject * o,QEvent *e)
	{
		if(o == ((QObject *)m_pPixLabel))
		{
			if(e->type() == QEvent::MouseButtonPress)
			{
				if(m_pTimer->isActive())
				{
					suicide(); // allow the user to hide the splash screen when 100% is reached
					return true;
				}
			}
		}
		return QWidget::eventFilter(o,e);
	}
	
	void KviSplashScreen::showEvent(QShowEvent *e)
	{
		move((g_pApp->desktop()->width() - width())/2,
			(g_pApp->desktop()->height() - height())/2);
		m_creationTime = QTime::currentTime();
	}
	
	void KviSplashScreen::setProgress(int progress)
	{
		m_pProgress->setProgress(progress);
		if(progress == 0)m_pPixLabel->repaint(false); // The label seems to need it! ... why? Qt knows..
		g_pApp->processEvents(); //damn...
	}
	
	void KviSplashScreen::setText(const QString &text)
	{
		m_pLabel->setText(text);
	}
	
	void KviSplashScreen::die()
	{
		QTime now = QTime::currentTime();
		int mSecs = m_creationTime.msecsTo(now);
		int mRemaining = KVI_SPLASH_SCREEN_MINIMUM_TIMEOUT_IN_MSECS - mSecs;
		if(mRemaining < 0)mRemaining = 0;
		m_pTimer->start(mRemaining,true);
	}
	
#endif

void KviSplashScreen::suicide()
{
#ifdef COMPILE_SPLASH_SCREEN
	if(!g_pSplashScreen)return; // already in suicide ?
	g_pSplashScreen = 0;
	delete this;
#endif
}

#include "kvi_splash.moc"
