#ifndef _ALIASEDITOR_H_
#define _ALIASEDITOR_H_
//
//   File : aliaseditor.h
//   Creation date : Mon Dec 23 2002 14:35:55 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the linkss of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_window.h"
#include "kvi_string.h"


#include <qwidget.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qpopupmenu.h>

class KviScriptEditor;

class KviAliasListViewItem : public QListViewItem
{
public:
	KviAliasListViewItem(QListView * par,const QString & name,const QString & buffer);
	~KviAliasListViewItem() {};
public:
	QString m_szName;
	QString m_szBuffer;
};


class KviAliasEditor : public QWidget
{
	Q_OBJECT
public:
	KviAliasEditor(QWidget * par);
	~KviAliasEditor();
public:
	KviScriptEditor      * m_pEditor;
	QListView            * m_pListView;
	QLineEdit            * m_pNameEditor;
	KviAliasListViewItem * m_pLastEditedItem;
	bool                   m_bOneTimeSetupDone;
	QPopupMenu           * m_pContextPopup;
public:
	void commit();
protected slots:
	void selectionChanged(QListViewItem *it);
	void newAlias();
	void removeCurrentAlias();
	void exportCurrentAlias();
	void exportAllAliases();
	void itemPressed(QListViewItem *it,const QPoint &pnt,int col);
protected:
	void showEvent(QShowEvent *e);
	void getExportAliasBuffer(QString &buffer,KviAliasListViewItem * it);
private:
	void oneTimeSetup();
	void saveLastEditedItem();
	void getUniqueHandlerName(KviAliasListViewItem *item,QString &buffer);
};


class KviAliasEditorWindow : public KviWindow
{
	Q_OBJECT
public:
	KviAliasEditorWindow(KviFrame * lpFrm);
	~KviAliasEditorWindow();
protected:
	KviAliasEditor * m_pEditor;
	QWidget        * m_pBase;
protected:
	virtual QPixmap * myIconPtr();
	virtual void resizeEvent(QResizeEvent *e);
	virtual void getConfigGroupName(KviStr &szName);
	virtual void saveProperties(KviConfig *);
	virtual void loadProperties(KviConfig *);
protected slots:
	void cancelClicked();
	void okClicked();
	void applyClicked();
};

#endif //_ALIASEDITOR_H_
