//
//   File : helpwindow.cpp
//   Creation date : Tue Aug 11 2000 18:08:22 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "helpwindow.h"
#include "helpwidget.h"

#include "kvi_iconmanager.h"
#include "kvi_options.h"
#include "kvi_locale.h"
#include "kvi_module.h"

#include <qlineedit.h>

extern KviPtrList<KviHelpWindow> * g_pHelpWindowList;
extern KviPtrList<KviHelpWidget> * g_pHelpWidgetList;

KviHelpWindow::KviHelpWindow(KviFrame * lpFrm,const char * name)
: KviWindow(KVI_WINDOW_TYPE_HELP,lpFrm,name)
{
	g_pHelpWindowList->append(this);
	m_pHelpWidget = new KviHelpWidget(this,lpFrm);
	// Ensure proper focusing
	//setFocusHandler(m_pHelpWidget->lineEdit(),this);
}

KviHelpWindow::~KviHelpWindow()
{
	g_pHelpWindowList->removeRef(this);
}

QTextBrowser * KviHelpWindow::textBrowser()
{
	return m_pHelpWidget->textBrowser();
}

QPixmap * KviHelpWindow::myIconPtr()
{
	return g_pIconManager->getSmallIcon(KVI_SMALLICON_MDIHELP);
}

void KviHelpWindow::resizeEvent(QResizeEvent *e)
{
	m_pHelpWidget->setGeometry(0,0,width(),height());
}

QSize KviHelpWindow::sizeHint() const
{
	return m_pHelpWidget->sizeHint();
}
void KviHelpWindow::fillCaptionBuffers()
{
	m_szPlainTextCaption = __tr2qs("Help Browser");

	m_szHtmlActiveCaption = "<nobr><font color=\"";
	m_szHtmlActiveCaption += KVI_OPTION_COLOR(KviOption_colorCaptionTextActive).name();
	m_szHtmlActiveCaption += "\"><b>";
	m_szHtmlActiveCaption += m_szPlainTextCaption;
	m_szHtmlActiveCaption += "</b></font></nobr>";


	m_szHtmlInactiveCaption = "<nobr><font color=\"";
	m_szHtmlInactiveCaption += KVI_OPTION_COLOR(KviOption_colorCaptionTextInactive).name();
	m_szHtmlInactiveCaption += "\"><b>";
	m_szHtmlInactiveCaption += m_szPlainTextCaption;
	m_szHtmlInactiveCaption += "</b></font></nobr>";
}

#include "helpwindow.moc"
