#ifndef _KVINOTIFIERWINDOWTABS_H_
#define _KVINOTIFIERWINDOWTABS_H_
//=============================================================================
//
//   File : kvinotifierwindowtabs.h
//   Created on dom 02 gen 2005 15:30:50 by Iacopo Palazzi
//
//   This file is part of the KVIrc distribution
//   Copyright (C) 2005 Iacopo Palazzi < iakko(at)siena(dot)linux(dot)it >
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include <qfont.h>
#include <qmap.h>
#include <qobject.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>

#include "kvi_list.h"
#include "notifiersettings.h"
#include "notifierwindow.h"

#include "notifiermessage.h"

class QPainter;

class KviNotifierWindowTab : public QObject // this class defines an object for every single tab about the tabs area
{
	Q_OBJECT
public:
	KviNotifierWindowTab(KviWindow *, QString);
	~KviNotifierWindowTab();
	
private:
	QString		m_label;
	QColor		m_cLabel;
	QColor		m_clrHighlightedLabel;
	QColor		m_clrNormalLabel;
	QColor		m_clrChangedLabel;
	QRect     		m_rect;
	TabState	                     m_eState;
	KviPtrList<KviNotifierMessage> * m_pMessageList;
	KviWindow * m_pWnd;
	KviNotifierMessage	* m_pCurrentMessage;
	bool		m_bFocused;
private slots:
	void labelChanged();
	void closeMe();
	
public:
	QString label() { return m_label; };
	void appendMessage(KviNotifierMessage * m);
	int countMessage() { return m_pMessageList->count(); };
	KviPtrList<KviNotifierMessage> * messageList() { return m_pMessageList; };
	
	void setRect(int x, int y, int w, int h) { m_rect.setX(x); m_rect.setY(y); m_rect.setWidth(w); m_rect.setHeight(h); };
	QRect rect() { return m_rect; };
	
	KviWindow * window() { return m_pWnd; };
	
	void setFocused(bool b = true);
	bool focused() { return m_bFocused; };
	
	void setCurrentMessage(KviNotifierMessage * m) { m_pCurrentMessage = m; };
	KviNotifierMessage * currentMessage() { return m_pCurrentMessage; };
	
	void setNextMessageAsCurrent();
	void setPrevMessageAsCurrent();
	void setLastMessageAsCurrent();
	
	void setState(TabState state){ m_eState=state;
										switch (m_eState) {
											case Normal:
												m_cLabel = m_clrNormalLabel;
												break;
											case Highlighted:
												m_cLabel = m_clrHighlightedLabel;
												break;
											case Changed:
												m_cLabel = m_clrChangedLabel;
												break;
										}
									};
									
	TabState state() { return m_eState; };
	
	QColor labelColor() {return m_cLabel; }
	
	KviWindow * wnd() {return m_pWnd; };
};


class KviNotifierWindowTabs // this class defines the tabs area
{
public:
	KviNotifierWindowTabs(QRect r);
	~KviNotifierWindowTabs();

// ================================
// Put members declaration below...
// ================================
private:
	QRect 	m_rct;
	QPoint	m_pnt;

	QMap<KviWindow *, KviNotifierWindowTab *> m_tabMap;
	
	QFont * m_pFocusedFont;
	QFont * m_pUnfocusedFont;
	
	KviNotifierWindowTab * m_pTabFocused;
	KviWindow * m_pWndTabFocused;

	QRect	m_rctCloseTabIcon;
	QRect	m_rctCloseTabIconHotArea;
	QRect	m_rctTabs;

	// Pictures
	QPixmap	m_pixDX;
	QPixmap	m_pixSX;
	QPixmap	m_pixBKG;
	QPixmap m_pixSXFocused;
	QPixmap m_pixDXFocused;
	QPixmap m_pixBKGFocused;
	QPixmap m_pixSXUnfocused;
	QPixmap m_pixDXUnfocused;
	QPixmap m_pixBKGUnfocused;

	QPixmap m_pixIconTabPrev;
	QPixmap m_pixIconTabPrev_out;
	QPixmap m_pixIconTabPrev_over;
	QPixmap m_pixIconTabPrev_clicked;
	
	QPixmap m_pixIconTabNext;
	QPixmap m_pixIconTabNext_out;
	QPixmap m_pixIconTabNext_over;
	QPixmap m_pixIconTabNext_clicked;

	QPixmap m_pixIconCloseTab;
	QPixmap m_pixIconCloseTab_off;
	QPixmap m_pixIconCloseTab_on;
	QPixmap m_pixIconCloseTab_clicked;

	int m_closeTabIconState;

	bool m_bNeedToRedraw;

public:

protected:


// ================================
// Put methods declaration below...
// ================================
private:
	void initConfig();
	void loadImages();

public:
	void setWidth(int w);
	void setPoint(int x, int y) { m_pnt.setX(x); m_pnt.setY(y); };
	void resize(QRect);
	
	void addMessage(KviWindow *, KviNotifierMessage *);

	void setFocusOn(KviNotifierWindowTab *);
	void needToRedraw() { m_bNeedToRedraw = true; };

	QRect rect() {return m_rct;};
	QRect rctCloseTabIconHotArea() {return m_rctCloseTabIconHotArea; };
	
	int x() { return m_pnt.x(); };
	int y() { return m_pnt.y(); };
	int width() { return m_rct.width(); };
	int height() { return m_rct.height(); };
	int baseLine() { return (y()+height()); };
		
	void recalculatePositions();
	void draw(QPainter *);

	KviNotifierWindowTab * currentTab(){ return m_pTabFocused; };

	void setCurrentMessage(KviNotifierMessage * m)
		{ if(m_pTabFocused)m_pTabFocused->setCurrentMessage(m); };
	KviNotifierMessage * currentMessage()
		{ return m_pTabFocused ? m_pTabFocused->currentMessage() : 0; };
	
	void markAllMessagesAsHistoric();
	void touch() { m_bNeedToRedraw = true; };

	void mouseMoveEvent(QMouseEvent * e);
	void mousePressEvent(QMouseEvent * e);
	void mouseReleaseEvent(QMouseEvent * e);

	void setCloseTabIcon(int state);
	int closeTabIconState() { return m_closeTabIconState; };
	
	void next();
	void prev();
	
	void closeTab(KviWindow * pWnd); // referes to void closeTab(KviWindow * pWnd, KviNotifierWindowTab * pTab);
	void closeTab(KviNotifierWindowTab * pTab); // referes to void closeTab(KviWindow * pWnd, KviNotifierWindowTab * pTab);
	void closeTab(KviWindow * pWnd, KviNotifierWindowTab * pTab);
	void closeCurrentTab();
	
	void resetIcons();

	int count() { return (int)m_tabMap.count(); };
	
	KviWindow * window() { return m_pTabFocused->wnd(); };

protected:

};

#endif //!_KVINOTIFIERWINDOWTABS_H_
