#ifndef _CLASS_MULTILINEEDIT_H_
#define _CLASS_MULTILINEEDIT_H_
//vim: ts=8
//   File : class_multilineedit.cpp
//   Creation date : Mon Feb 19 00:45:34 CET by Krzysztof Godlewski
//
//	 Modification date: Thu 15 Feb 2005 22:00 :00
//	 by Tonino Imbesi(Grifisx) and Alessandro Carbone(Noldor)
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "class_widget.h"
#include <qmultilineedit.h>


class KviScriptMLEditObject : public KviScriptWidgetObject
{
	Q_OBJECT
public:
	KviScriptMLEditObject(KviScriptObjectClass *, KviScriptObject *,
		const char *);
	~KviScriptMLEditObject();
	
	static void registerSelf();
	static void unregisterSelf();

protected:
	virtual bool init(KviCommand *);

	bool functionTextLine(KviCommand *, KviParameterList *, KviStr &);
	bool functionInsertLine(KviCommand *, KviParameterList *, KviStr &);
	bool functionRemoveLine(KviCommand *, KviParameterList *, KviStr &);
	bool functionInsertAt(KviCommand *, KviParameterList *, KviStr &);
	bool functionNumLines(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetCursorPosition(KviCommand *, KviParameterList *, KviStr &);
	bool functionCursorPosition(KviCommand *, KviParameterList *, KviStr &);
	bool functionAtBeginning(KviCommand *, KviParameterList *, KviStr &);
	bool functionAtEnd(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetWordWrap(KviCommand *, KviParameterList *, KviStr &);
	bool functionWordWrap(KviCommand *, KviParameterList *, KviStr &);
	bool functionText(KviCommand *, KviParameterList *, KviStr &);
	bool functionLength(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetMaxLines(KviCommand *, KviParameterList *, KviStr &);
	bool functionMaxLines(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetReadOnly(KviCommand *,KviParameterList *,KviStr &);
	bool functionInsert(KviCommand *, KviParameterList *, KviStr &);
	bool functionAppend(KviCommand *, KviParameterList *, KviStr &);
	bool functionCopy(KviCommand *, KviParameterList *, KviStr &);
	bool functionPaste(KviCommand *, KviParameterList *, KviStr &);
	bool functionCut(KviCommand *, KviParameterList *, KviStr &);
//								|-G&N add-| 
	bool functionsetItalic(KviCommand *, KviParameterList *, KviStr &);
	bool functionitalic(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetBold(KviCommand *, KviParameterList *, KviStr &);
	bool functionbold(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetUnderline(KviCommand *, KviParameterList *, KviStr &);
	bool functionunderline(KviCommand *, KviParameterList *, KviStr &);
	bool functionzoomIn(KviCommand *, KviParameterList *, KviStr &);
    bool functionzoomOut(KviCommand *, KviParameterList *, KviStr &);
    bool functionzoomTo(KviCommand *, KviParameterList *, KviStr &);
	bool functionundo(KviCommand *, KviParameterList *, KviStr &);
    bool functionredo(KviCommand *, KviParameterList *, KviStr &);
    bool functiondel(KviCommand *, KviParameterList *, KviStr &);
    bool functionclear(KviCommand *, KviParameterList *, KviStr &);
    bool functionindent(KviCommand *, KviParameterList *, KviStr &);
    bool functionsetUndoRedoEnabled(KviCommand *, KviParameterList *, KviStr &);
    bool functionsetUndoDepth(KviCommand *, KviParameterList *, KviStr &);
    bool functionisUndoRedoEnabled(KviCommand *, KviParameterList *, KviStr &);
    bool functionundoDepth(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetText(KviCommand *, KviParameterList *, KviStr &);
    bool functionsetPointSize(KviCommand *, KviParameterList *, KviStr &);
    bool functionsetColor(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetLinkUnderline(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetFamily(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetModified(KviCommand *, KviParameterList *, KviStr &);
	bool functioninsertParagraph(KviCommand *, KviParameterList *, KviStr &);
	bool functionremoveParagraph(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetOverwriteMode(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetTextFormat(KviCommand *, KviParameterList *, KviStr &);
	bool functiontextFormat(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetParagraphBackgroundColor(KviCommand *, KviParameterList *, KviStr &);
	bool functionclearParagraphBackground(KviCommand *, KviParameterList *, KviStr &);
	bool functionloadFile(KviCommand *, KviParameterList *, KviStr &);
	bool functionisUndoAvailable(KviCommand *, KviParameterList *, KviStr &);
	bool functionisRedoAvailable(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetAlignment(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetAutoFormatting(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetVerticalAlignment(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetWrapPolicy(KviCommand *, KviParameterList *, KviStr &);
	bool functionparagraphs(KviCommand *, KviParameterList *, KviStr &);
	bool functionparagraphLength(KviCommand *, KviParameterList *, KviStr &);
	bool functionlines(KviCommand *, KviParameterList *, KviStr &);
	bool functionlineOfChar(KviCommand *, KviParameterList *, KviStr &);
	bool functionlinesOfParagraph(KviCommand *, KviParameterList *, KviStr &);
	bool functionselectAll(KviCommand *, KviParameterList *, KviStr &);

	
};

#endif	//!_CLASS_MULTILINEEDIT_H_
