#ifndef	_CLASS_PROCESS_H_
#define	_CLASS_PROCESS_H_
//mdm:
//   File : class_process.h
//   Creation date : Thu Feb 1 14:39:48 CEST 2005 
//	 by Tonino Imbesi(Grifisx) and Alessandro Carbone(Noldor)
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <qprocess.h>
#include <qtimer.h>
#include "class_widget.h"

class KviScriptProcessObject : public KviScriptWidgetObject
{
	Q_OBJECT
public:
	KviScriptProcessObject(KviScriptObjectClass * c, KviScriptObject * p, 
		const char * n);
	virtual ~KviScriptProcessObject();

	static void registerSelf();
	static void unregisterSelf();

protected:

	bool functionaddArgument(KviCommand *, KviParameterList *, KviStr &);
	bool functionstartProcess(KviCommand *, KviParameterList *, KviStr &);
	bool functionreadStdout(KviCommand *, KviParameterList *, KviStr &);

	bool functionreadStderr(KviCommand *, KviParameterList *, KviStr &);
	bool functionwriteToStdin(KviCommand *, KviParameterList * ,KviStr &);
	bool functionclosekill(KviCommand *, KviParameterList * ,KviStr &);
	bool functioncloseStdin(KviCommand *, KviParameterList *, KviStr &);
	bool functionkill(KviCommand *, KviParameterList * ,KviStr &);
	bool functiontryTerminate(KviCommand *, KviParameterList * ,KviStr &);
	bool functionnormalExit(KviCommand *, KviParameterList * ,KviStr &);
	bool functionisRunning(KviCommand *, KviParameterList * ,KviStr &);
	bool functionreadyReadStdoutEvent(KviCommand *, KviParameterList *, KviStr &);
	bool functionreadyReadStderrEvent(KviCommand *, KviParameterList *, KviStr &);

protected:
	QProcess * m_pProcess;
protected slots:
	void slotReadStdout();
	void slotReadStderr();
};

#endif	// !_CLASS_PROCESS_H_
