//
//   File : class_progressbar.cpp
//   Creation date : Thu Feb 08 14:21:48 CEST 2005 
//   by Tonino Imbesi(Grifisx) and Alessandro Carbone(Noldor)
// 
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2005 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "class_radiobutton.h"
#include "kvi_error.h"
#include "kvi_debug.h"
#include "kvi_command.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"

static KviScriptObjectClass * g_pRadioButtonClass = 0;

static KviScriptObject * RadioButtonClassCreateInstance(KviScriptObjectClass * c,
	KviScriptObject * p, const char * n)
{
	return new KviScriptRadioButtonObject(c, p, n);
}

KviScriptRadioButtonObject::KviScriptRadioButtonObject(KviScriptObjectClass * c, KviScriptObject * p,
	const char *n) : KviScriptWidgetObject(c, p, n)
{
}

KviScriptRadioButtonObject::~KviScriptRadioButtonObject()
{
}
/*
	@doc: radiobutton
	@keyterms:
		radiobutton widget class
	@title:
		radiobutton class
	@type:
		class
	@short:
		A radiobutton class
	@inherits:
		[class]widget[/class]
	@description:
		The RadioButton widget provides a radio button with a text or pixmap label.
	@functions:
		!fn: $settext(<text>)
		Sets the text that will appear in the radiobutton.
		!fn: $isChecked(<bool>)
		Returns TRUE if the radio button is checked; otherwise returns FALSE. 
		!fn: $setChecked(<bool(1 or 0)>)
		Sets whether the radio button is checked to check.
		!fn: $setPixmap(<image id>)
		Sets the pixmap shown on the radiobutton..See the [doc:image_id]image identifier[/doc] documentation for the explaination
		of the <image_id> parameter.
		

*/

bool KviScriptRadioButtonObject::init(KviCommand *)
{
	setObject(new QRadioButton(parentScriptWidget(), name()), true);
/*	connect(widget(),SIGNAL(clicked()),this,SLOT(slotClicked()));
	connect(widget(),SIGNAL(pressed()),this,SLOT(slotPressed()));
	connect(widget(),SIGNAL(released()),this,SLOT(slotReleased()));*/
	return true;
}

#define radiobuttonFuncReg(__nam, __func) \
	g_pRadioButtonClass->registerFunctionHandler(__nam, \
	(KviScriptObjectFunctionHandlerProc)(KVI_PTR2MEMBER(KviScriptRadioButtonObject::__func)), \
	0, true);

void KviScriptRadioButtonObject::registerSelf()
{
	KviScriptObjectClass * base = g_pScriptObjectController-> \
		lookupClass("widget");
	__range_valid(base);

	g_pRadioButtonClass = new KviScriptObjectClass(base, "radiobutton",
		RadioButtonClassCreateInstance, true);

	radiobuttonFuncReg("setText", functionsetText);
	radiobuttonFuncReg("setChecked", functionsetChecked);
	radiobuttonFuncReg("isChecked", functionisChecked);
	radiobuttonFuncReg("setPixmap", functionsetPixmap);
/*	radiobuttonFuncReg("clickedEvent", functionclickedEvent);
	radiobuttonFuncReg("pressedEvent", functionpressedEvent);
	radiobuttonFuncReg("releasedEvent", functionreleasedEvent);*/
}

void KviScriptRadioButtonObject::unregisterSelf()
{
	delete g_pRadioButtonClass;
    g_pRadioButtonClass = 0;
}

bool KviScriptRadioButtonObject::functionsetText(KviCommand *, KviParameterList * p, \
	KviStr &)
{
	if(widget())
	{
		if(p->first())
			((QRadioButton *)widget())->setText(p->first()->ptr());
		else
			((QRadioButton *)widget())->setText("");
	}
	return true;
}

bool KviScriptRadioButtonObject::functionsetChecked(KviCommand *,KviParameterList * p,
	KviStr &)
{
	if(widget())
	{
		((QRadioButton *)widget())->setChecked(p->getBool());
	}
	return true;
}

bool KviScriptRadioButtonObject::functionisChecked(KviCommand *,KviParameterList * p,
	KviStr &b)
{

	if(widget())
	    b.append(((QRadioButton *) widget())->isChecked() ? '1' : '0');
	return true;
}
bool KviScriptRadioButtonObject::functionsetPixmap(KviCommand *c, KviParameterList *p, KviStr & b)
{
	KviStr * pPix = p->safeFirst();
	QPixmap * pix = 0;
	
	if(!pPix)
		return c->error(KviError_notEnoughParameters);
	
	pix = g_pIconManager->getImage(pPix->ptr());
                
	if(pix)
	{
		((QRadioButton *)widget())->setPixmap(*pix);
		return c->leaveStackFrame();
	}
	c->warning(__tr("Invalid icon identifier"));
    return c->leaveStackFrame();
}

/*
bool KviScriptRadioButtonObject::functionclickedEvent(KviCommand *c, KviParameterList *,	
	KviStr & b)
{

	ENTER_STACK_FRAME(c,"radiobutton::clickedEvent");
	emitSignal("clicked",0,0,c);
	return c->leaveStackFrame();

}

bool KviScriptRadioButtonObject::functionpressedEvent(KviCommand *c, KviParameterList *,	
	KviStr & b)
{

	ENTER_STACK_FRAME(c,"radiobutton::pressedEvent");
	emitSignal("pressed",0,0,c);
	return c->leaveStackFrame();

}

bool KviScriptRadioButtonObject::functionreleasedEvent(KviCommand *c, KviParameterList *,	
	KviStr & b)
{

	ENTER_STACK_FRAME(c,"radiobutton::releasedEvent");
	emitSignal("released",0,0,c);
	return c->leaveStackFrame();

}

void KviScriptRadioButtonObject::slotClicked()
{

	callEventFunction("clickedEvent");
}

void KviScriptRadioButtonObject::slotReleased()
{

	callEventFunction("pressedEvent");
}

void KviScriptRadioButtonObject::slotPressed()
{

	callEventFunction("releasedEvent");
}
*/
#include "m_class_radiobutton.moc"
