//mdm :
//   File : class_Slider.cpp
//   Creation date : Mon Gen 27 21:30:48 CEST 2005 
//	 by Tonino Imbesi(Grifisx) and Alessandro Carbone(Noldor)
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "class_slider.h"
#include "kvi_error.h"

#include "kvi_debug.h"
#include "kvi_command.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"


static KviScriptObjectClass * g_pSliderClass = 0;

static KviScriptObject * sliderClassCreateInstance(KviScriptObjectClass * c,
	KviScriptObject * p, const char * n)
{
	return new KviScriptSliderObject(c, p, n);
}

KviScriptSliderObject::KviScriptSliderObject(KviScriptObjectClass * c, KviScriptObject * p,
	const char *n) : KviScriptWidgetObject(c, p, n)
{
}

KviScriptSliderObject::~KviScriptSliderObject()
{
}

/*
@doc:	slider
	@keyterms:
		slider object class
	@title:
		slider class
	@type:
		class
	@short:
		The slider widget provides a vertical or horizontal slider.
	@inherits:
		[class]object[/class]
		[class]widget[/class]
	@description:
		The slider is the classic widget for controlling a bounded value.[br]
		It lets the user move a slider along a horizontal or vertical groove [br]
		and translates the slider's position into an integer value within the legal range.[/classfnc]() 
	@functions:
		!fn: $setOrientation(<orientation>)
		Sets the slider's orientation.[br]
		Orientation value can be "Horizontal" or "Vertical"[br]
		!fn: $setTracking(<bool>)
		Sets whether slider tracking is enabled to enable.[br]
		Value can be 1 or 0.[br]
		!fn: $setMaxValue(<value>)
		Sets maximum value for slider's range.[br]
		!fn: $setMinValue(<value>)
		Sets minimum value for slider's range.[br]
		!fn: $setLineStep(<value>)
		Sets the  line step to <value>.[br]
		!fn: $setPageStep(<value>)
		Sets the  page step to <value>.[br]
		!fn: $setTickmarks(<value>)
		Sets the tickmark settings for this slider.[br]
		Values are:[br]
		NoMarks - do not draw any tickmarks.[br]
		Both - draw tickmarks on both sides of the groove.[br]
		Above - draw tickmarks above the (horizontal) slider[br]
		Below - draw tickmarks below the (horizontal) slider[br]
		Left - draw tickmarks to the left of the (vertical) slider[br]
		Right - draw tickmarks to the right of the (vertical) slider[br]
		!fn: $setTickInterval(<value>)
		Sets the interval between tickmarks.[br]
		!fn: $value()
		Returns slider value.[br]
		!fn: $minValue()
		Returns slider minValue.[br]
		!fn: $maxValue()
		Returns slider maxValue.[br]
		!fn: $lineStep()
		Returns slider lineStep value.[br]
		!fn: $pageStep()
		Returns slider pageStep value.[br]
		!fn: $valueChangedEvent(<new slider valure>)
		This function is called by the framework when the slider value is changed and return the new slider value as its argument.[br]
		The default implementation emits the [classfnc]$valueChanged[/classfnc]() signal,
		so it is easy to handle the values from many sliders without reimplementing
		the [classfnc]$valueChangedEvent[/classfnc]() for every one.[br]
		Note:[br]
		If you reimplement this function to catch the slider value, you will have
		to emit the signal by yourself (if you still need it , obviously).[br]
		@signals:
		!sg: $valueChanged()
		This signal is emitted by the default implementation of [classfnc]valueChangedEvent[/classfnc]().[br]
		If you reimplement that function you will have to emit the signal manually (if you still need it).[br]

*/



bool KviScriptSliderObject::init(KviCommand *)
{
	setObject(new QSlider(parentScriptWidget(), name()), true);
	connect(widget(),SIGNAL(valueChanged(int)),this,SLOT(valueChanged(int)));

	return true;
}

#define SliderFuncReg(__nam, __func) \
	g_pSliderClass->registerFunctionHandler(__nam, \
	(KviScriptObjectFunctionHandlerProc)(KVI_PTR2MEMBER(KviScriptSliderObject::__func)), \
	0, true);

void KviScriptSliderObject::registerSelf()
{
	KviScriptObjectClass * base = g_pScriptObjectController-> \
		lookupClass("widget");
	__range_valid(base);

	g_pSliderClass = new KviScriptObjectClass(base, "slider", 
		sliderClassCreateInstance, true);

	SliderFuncReg("setOrientation", functionsetOrientation);
	SliderFuncReg("setValue", functionsetValue);
	SliderFuncReg("setTracking", functionsetTracking);
	SliderFuncReg("setMinValue", functionsetMinValue);
	SliderFuncReg("setMaxValue", functionsetMaxValue);
	SliderFuncReg("setLineStep", functionsetLineStep);
	SliderFuncReg("setPageStep", functionsetPageStep);
	SliderFuncReg("setTickmarks", functionsetTickmarks);
	SliderFuncReg("setTickInterval", functionsetTickInterval);
	SliderFuncReg("value",functionValue);
	SliderFuncReg("minValue", functionminValue);
	SliderFuncReg("maxValue", functionmaxValue);
	SliderFuncReg("lineStep", functionlineStep);
	SliderFuncReg("pageStep", functionpageStep);
	SliderFuncReg("valueChangedEvent", functionvalueChangedEvent);


}

void KviScriptSliderObject::unregisterSelf()
{
	delete g_pSliderClass;
    g_pSliderClass = 0;
}

bool KviScriptSliderObject::functionsetTracking(KviCommand *,KviParameterList * p,
	KviStr &)
{
	if(widget())
	{
		((QSlider *)widget())->setTracking(p->getBool());
	}
	return true;
}


bool KviScriptSliderObject::functionsetValue(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "slider::setValue");
	if(!widget())
	    return c->leaveStackFrame(); 
	bool bOk;
	int val = p->getInt(&bOk);
	if(bOk)
	    ((QSlider *)widget())->setValue(val);
	else
	    c->warning(__tr("Invalid  parameter"));
	return c->leaveStackFrame();

}

bool KviScriptSliderObject::functionsetMinValue(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "slider::setMinValue");
	if(!widget())
	    return c->leaveStackFrame(); 
	bool bOk;
	int val = p->getInt(&bOk);
	if(bOk)
	    ((QSlider *)widget())->setMinValue(val);
	else
	    c->warning(__tr("Invalid  parameter"));
	return c->leaveStackFrame();

}


bool KviScriptSliderObject::functionsetLineStep(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "slider::setLineStep");
	if(!widget())
	    return c->leaveStackFrame(); 
	bool bOk;
	int val = p->getInt(&bOk);
	if(bOk)
	    ((QSlider *)widget())->setLineStep(val);
	else
	    c->warning(__tr("Invalid  parameter"));
	return c->leaveStackFrame();

}

bool KviScriptSliderObject::functionsetPageStep(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "slider::setPageStep");
	if(!widget())
	    return c->leaveStackFrame(); 
	bool bOk;
	int val = p->getInt(&bOk);
	if(bOk)
	    ((QSlider *)widget())->setPageStep(val);
	else
	    c->warning(__tr("Invalid  parameter"));
	return c->leaveStackFrame();

}

bool KviScriptSliderObject::functionsetMaxValue(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "slider::setMaxValue");
	if(!widget())
	    return c->leaveStackFrame(); 
	bool bOk;
	int val = p->getInt(&bOk);
	if(bOk)
	    ((QSlider *)widget())->setMaxValue(val);
	else
	    c->warning(__tr("Invalid  parameter"));
	return c->leaveStackFrame();

}


bool KviScriptSliderObject::functionsetOrientation(KviCommand * c, KviParameterList * params,
	KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"slider::setOrientation");
	KviStr * pModoS = params->safeFirst();
	QString modosoS = pModoS->ptr();
	if(widget())
	{

		if(modosoS=="Horizontal")
			((QSlider *)widget())->setOrientation(Qt::Horizontal);
		if(modosoS=="Vertical")
			((QSlider *)widget())->setOrientation(Qt::Vertical);
	}

	return true;
}

bool KviScriptSliderObject::functionsetTickmarks(KviCommand * c, KviParameterList * params,
	KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"slider::setTickmarks");
	KviStr * pModos = params->safeFirst();
	if(widget())
	{
		if(kvi_strEqualCI(pModos->ptr(),"NoMarks"))
			((QSlider *)widget())->setTickmarks(QSlider::NoMarks);
		if(kvi_strEqualCI(pModos->ptr(),"Both"))
			((QSlider *)widget())->setTickmarks(QSlider::Both);
		if(kvi_strEqualCI(pModos->ptr(),"Above"))
			((QSlider *)widget())->setTickmarks(QSlider::Above);
		if(kvi_strEqualCI(pModos->ptr(),"Below"))
			((QSlider *)widget())->setTickmarks(QSlider::Below);
		if(kvi_strEqualCI(pModos->ptr(),"Left"))
			((QSlider *)widget())->setTickmarks(QSlider::Left);
		if(kvi_strEqualCI(pModos->ptr(),"Right"))
			((QSlider *)widget())->setTickmarks(QSlider::Right);
	}

	return true;
}

bool KviScriptSliderObject::functionsetTickInterval(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "slider::setTickInterval");
	if(!widget())
	    return c->leaveStackFrame(); 
	bool bOk;
	int val = p->getInt(&bOk);
	if(bOk)
	    ((QSlider *)widget())->setTickInterval(val);
	else
	    c->warning(__tr("Invalid  parameter"));
	return c->leaveStackFrame();

}

bool KviScriptSliderObject::functionValue(KviCommand *c, KviParameterList *,	
	KviStr & b)
{
	if(widget())b.append(KviStr::Format,"%d",((QSlider *)widget())->value());
	return true;
}

bool KviScriptSliderObject::functionminValue(KviCommand *c, KviParameterList *,	
	KviStr & b)
{
	if(widget())b.append(KviStr::Format,"%d",((QSlider *)widget())->minValue());
	return true;
}

bool KviScriptSliderObject::functionmaxValue(KviCommand *c, KviParameterList *,	
	KviStr & b)
{
	if(widget())b.append(KviStr::Format,"%d",((QSlider *)widget())->maxValue());
	return true;
}

bool KviScriptSliderObject::functionlineStep(KviCommand *c, KviParameterList *,	
	KviStr & b)
{
	if(widget())b.append(KviStr::Format,"%d",((QSlider *)widget())->lineStep());
	return true;
}

bool KviScriptSliderObject::functionpageStep(KviCommand *c, KviParameterList *,	
	KviStr & b)
{
	if(widget())b.append(KviStr::Format,"%d",((QSlider *)widget())->pageStep());
	return true;
}

bool KviScriptSliderObject::functionvalueChangedEvent(KviCommand *c, KviParameterList *,	
	KviStr & b)
{

	ENTER_STACK_FRAME(c,"slider::valueChangedEvent");
	emitSignal("valueChanged",0,0,c);
	return c->leaveStackFrame();

}

void KviScriptSliderObject::valueChanged(int i)
{
	KviStr * s = new KviStr();
	s->setNum(i);
	callEventFunction("valueChangedEvent",0,new KviParameterList(s));
}

#include "m_class_slider.moc"
