//
//   File : class_progressbar.cpp
//   Creation date : Fri Jan 30 14:21:48 CEST 2005 
//   by Tonino Imbesi(Grifisx) and Alessandro Carbone(Noldor)
// 
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2005 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qspinbox.h>
#include "class_spinbox.h"
#include "kvi_error.h"
#include "kvi_debug.h"
#include "kvi_command.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"

/*
	@doc:	spinbox
	@keyterms:
		spinbox object class,
	@title:
		spinbox class
	@type:
		class
	@short:
		Provides a simple spin button.
	@inherits:
		[class]object[/class]
		[class]widget[/class]
	@description:
		This widget allows the user to choose a value either by clicking the up/down buttons
		to increase/decrease the value currently displayed or by typing the value directly into the spin box.
	@functions:
		!fn: $setValue(<value>)
		Sets the value of the spin box.[br]
		See also [classfnc]$value[/classfnc]()
		!fn: $setMinValue(<value>)
		Sets the minimum value of the spin box.
		See also [classfnc]$MinValue[/classfnc]()
		!fn: $setMaxValue(<value>)
		Sets the maximum value of the spin box.[br]
		See also [classfnc]$maxValue[/classfnc]() 
		!fn: $setLineStep(<value>)
		Sets the  line step: when the user uses the arrows to change the spin box's value the value will be
		incremented/decremented by the amount of the line step.
		See also [classfnc]$lineStep[/classfnc]()
		!fn: $setSpecialValueText(<text>)
		Sets the special-value text.
		If set, the spin box will display this text instead of a numeric value whenever the current value is equal to [classfnc]$minValue[/classfnc]().
		See also [classfnc]$setSpecialValueText[/classfnc]()
		!fn: $setPrefix
		This property holds the spin box's prefix.[br]
		The prefix is prepended to the start of the displayed value.[br]
		Typical use is to display a unit of measurement or a currency symbol.
		See also [classfnc]$setSuffix[/classfnc]()
		!fn: $setSuffix();
		This property holds the suffix of the spin box.[br]
		The suffix is appended to the end of the displayed value.[br]
		See also [classfnc]$setPrefix[/classfnc]()
		!fn: $value()
		Returns the value of the spin box.
		See also [classfnc]$setValue[/classfnc]()
		!fn: $minValue
		Returns the minimum value of the spin box.
		See also [classfnc]$setMinValue[/classfnc]()
		!fn: $maxValue
		Returns the maximum value of the spin box.
		See also [classfnc]$setMaxValue[/classfnc]()
		!fn: $lineStep()
		Return the linestep.
		!fn: $specialValueText()
		Returns the special-value text.
		See also [classfnc]$setSpecialValueText[/classfnc]()
*/

static KviScriptObjectClass * g_pSpinboxClass = 0;

static KviScriptObject * SpinboxClassCreateInstance(KviScriptObjectClass * c,
	KviScriptObject * p, const char * n)
{
	return new KviScriptSpinboxObject(c, p, n);
}

KviScriptSpinboxObject::KviScriptSpinboxObject(KviScriptObjectClass * c, KviScriptObject * p,
	const char *n) : KviScriptWidgetObject(c, p, n)
{
}

KviScriptSpinboxObject::~KviScriptSpinboxObject()
{
}

bool KviScriptSpinboxObject::init(KviCommand *)
{
	setObject(new QSpinBox(parentScriptWidget(), name()), true);
	return true;
}

#define spinboxFuncReg(__nam, __func) \
	g_pSpinboxClass->registerFunctionHandler(__nam, \
	(KviScriptObjectFunctionHandlerProc)(KVI_PTR2MEMBER(KviScriptSpinboxObject::__func)), \
	0, true);

void KviScriptSpinboxObject::registerSelf()
{
	KviScriptObjectClass * base = g_pScriptObjectController-> \
		lookupClass("widget");
	__range_valid(base);

	g_pSpinboxClass = new KviScriptObjectClass(base, "spinbox",
		SpinboxClassCreateInstance, true);

	spinboxFuncReg("setValue", functionsetValue);
	spinboxFuncReg("setMinValue", functionsetMinValue);
	spinboxFuncReg("setMaxValue", functionsetMaxValue);
	spinboxFuncReg("setLineStep", functionsetLineStep);
	spinboxFuncReg("setSpecialValueText", functionsetSpecialValueText);
	spinboxFuncReg("setSuffix", functionsetSuffix);
	spinboxFuncReg("setPrefix", functionsetPrefix);
	spinboxFuncReg("value", functionValue);
	spinboxFuncReg("minValue", functionminValue);
	spinboxFuncReg("maxValue", functionmaxValue);
	spinboxFuncReg("lineStep", functionlineStep);
	spinboxFuncReg("specialValueText", functionspecialValueText);

  }

void KviScriptSpinboxObject::unregisterSelf()
{
	delete g_pSpinboxClass;
    g_pSpinboxClass = 0;
}

bool KviScriptSpinboxObject::functionsetValue(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "spinbox::setValue");
	if(!widget())
	    return c->leaveStackFrame(); 
	bool bOk;
	int val = p->getInt(&bOk);
	if(bOk)
	    ((QSpinBox *)widget())->setValue(val);
	else
	    c->warning(__tr("Invalid  parameter"));
	return c->leaveStackFrame();

}

bool KviScriptSpinboxObject::functionsetMaxValue(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "spinbox::setMaxValue");
	if(!widget())
	    return c->leaveStackFrame(); 
	bool bOk;
	int val = p->getInt(&bOk);
	if(bOk)
	    ((QSpinBox *)widget())->setMaxValue(val);
	else
	    c->warning(__tr("Invalid  parameter"));
	return c->leaveStackFrame();

}


bool KviScriptSpinboxObject::functionsetMinValue(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "spinbox::setMinValue");
	if(!widget())
	    return c->leaveStackFrame(); 
	bool bOk;
	int val = p->getInt(&bOk);
	if(bOk)
	    ((QSpinBox *)widget())->setMinValue(val);
	else
	    c->warning(__tr("Invalid  parameter"));
	return c->leaveStackFrame();

}

bool KviScriptSpinboxObject::functionsetLineStep(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	ENTER_STACK_FRAME(c, "spinbox::setLineStep");
	if(!widget())
	    return c->leaveStackFrame(); 
	bool bOk;
	int val = p->getInt(&bOk);
	if(bOk)
	    ((QSpinBox *)widget())->setLineStep(val);
	else
	    c->warning(__tr("Invalid  parameter"));
	return c->leaveStackFrame();

}

bool KviScriptSpinboxObject::functionsetSpecialValueText(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	if(widget())
	{
		if(p->first())
			((QSpinBox *)widget())->setSpecialValueText(p->first()->ptr());
		else
			((QSpinBox *)widget())->setSpecialValueText("");
	}
	return true;
}

bool KviScriptSpinboxObject::functionsetPrefix(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	if(widget())
	{
		if(p->first())
			((QSpinBox *)widget())->setPrefix(p->first()->ptr());
		else
			((QSpinBox *)widget())->setPrefix("");
	}
	return true;
}

bool KviScriptSpinboxObject::functionsetSuffix(KviCommand * c, KviParameterList * p, \
	KviStr & b)
{
	if(widget())
	{
		if(p->first())
			((QSpinBox *)widget())->setSuffix(p->first()->ptr());
		else
			((QSpinBox *)widget())->setSuffix("");
	}
	return true;
}

bool KviScriptSpinboxObject::functionValue(KviCommand *c, KviParameterList *,	
	KviStr & b)
{
	if(widget())b.append(KviStr::Format,"%d",((QSpinBox *)widget())->value());
	return true;
}

bool KviScriptSpinboxObject::functionminValue(KviCommand *c, KviParameterList *,	
	KviStr & b)
{
	if(widget())b.append(KviStr::Format,"%d",((QSpinBox *)widget())->minValue());
	return true;
}

bool KviScriptSpinboxObject::functionmaxValue(KviCommand *c, KviParameterList *,	
	KviStr & b)
{
	if(widget())b.append(KviStr::Format,"%d",((QSpinBox *)widget())->maxValue());
	return true;
}

bool KviScriptSpinboxObject::functionlineStep(KviCommand *c, KviParameterList *,	
	KviStr & b)
{
	if(widget())b.append(KviStr::Format,"%d",((QSpinBox *)widget())->lineStep());
	return true;
}
bool KviScriptSpinboxObject::functionspecialValueText(KviCommand *c, KviParameterList *,	
	KviStr & b)
{
	if(widget())
	{
		QString svt = ((QSpinBox *)widget())->specialValueText();
		QCString svtc = svt.utf8();
		if(!svtc.isEmpty())
		
			b.append(KviStr::Format,"%s",svtc.data());
	}
	return true;
}

#include "m_class_spinbox.moc"
