#ifndef	_CLASS_TABWIDGET_H_
#define	_CLASS_TABWIDGET_H_
//mdm:
//   File : class_tabwidget.h
//   Creation date : Fri Feb 11 10:21:48 CEST 2005
//   by Tonino Imbesi(Grifisx) and Alessandro Carbone(Noldor)
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2005 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include <qtabwidget.h>
#include "class_widget.h"

class KviScriptTabWidgetObject : public KviScriptWidgetObject
{
	Q_OBJECT
public:
	KviScriptTabWidgetObject(KviScriptObjectClass * c, KviScriptObject * p, 
		const char * n);
	virtual ~KviScriptTabWidgetObject();

	static void registerSelf();
	static void unregisterSelf();

protected:
	virtual bool init(KviCommand *);

	bool functionaddTab(KviCommand *, KviParameterList *, KviStr &);
	bool functioninsertTab(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetTabToolTip(KviCommand *, KviParameterList *, KviStr &);
	bool functionremoveTabToolTip(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetTabLabel(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetCurrentPage(KviCommand *, KviParameterList *, KviStr &);
	bool functioncurrentPageIndex(KviCommand *, KviParameterList *, KviStr &);
	bool functiontabLabel(KviCommand *, KviParameterList *, KviStr &);
	bool functioncurrentTabLabel(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetMargin(KviCommand *, KviParameterList *, KviStr &);
	bool functionmargin(KviCommand *, KviParameterList *, KviStr &);
	bool functioncount(KviCommand *, KviParameterList *, KviStr &);
	bool functionchangeTab(KviCommand *, KviParameterList *, KviStr &);
	bool functioncurrentChangedEvent(KviCommand *, KviParameterList * ,KviStr &);
	bool functionremovePage(KviCommand *, KviParameterList * ,KviStr &);
	bool functionsetTabPosition(KviCommand *, KviParameterList * ,KviStr &);

protected slots:
	void slotcurrentChanged(int);	
 };

#endif	//!_CLASS_TABWIDGET_H_
