//
//   File : class_window.cpp
//   Creation date : Tue Now 26 21:39:59 CEST 2002 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//



#include "class_window.h"

#include "kvi_error.h"
#include "kvi_debug.h"
#include "kvi_command.h"
#include "kvi_locale.h"
#include "kvi_frame.h"

static KviScriptObjectClass * g_pWindowClass = 0;





KviScriptWindowWindow::KviScriptWindowWindow(KviFrame * pParent,const QString &szName)
: KviWindow(KVI_WINDOW_TYPE_SCRIPTOBJECT,pParent,szName)
{
	m_pCentralWidget = 0;
	setBackgroundMode(QWidget::NoBackground);
}

KviScriptWindowWindow::~KviScriptWindowWindow()
{
}

void KviScriptWindowWindow::setCentralWidget(KviScriptWidgetObject *o,QWidget * w)
{
	m_pCentralWidgetObject = o;
	m_pCentralWidget = w;
}

void KviScriptWindowWindow::resizeEvent(QResizeEvent *e)
{
	if(m_pCentralWidget)
		m_pCentralWidget->setGeometry(0,0,width(),height());
}

void KviScriptWindowWindow::centralWidgetObjectDestroyed()
{
	m_pCentralWidget = 0;
	m_pCentralWidgetObject = 0;
}

void KviScriptWindowWindow::centralWidgetDestroyed()
{
	m_pCentralWidget = 0;
	m_pCentralWidgetObject = 0;
}





static KviScriptObject * windowClassCreateInstance(KviScriptObjectClass * c,
	KviScriptObject * p, const char * n)
{
	return new KviScriptWindowObject(c, p, n);
}

KviScriptWindowObject::KviScriptWindowObject(KviScriptObjectClass * c, KviScriptObject * p,
	const char *n) : KviScriptWidgetObject(c, p, n)
{
}

KviScriptWindowObject::~KviScriptWindowObject()
{
}

/*
	@doc:	window
	@title:
		window class
	@type:
		class
	@short:
		A MDI window object
	@inherits:
		[class]object[/class]
		[class]widget[/class]
	@description:
		This class rappresents a MDI window in a KVIrc frame.
		Regardless of the parent object passed, the window will be always
		a "physical" child of the frame window: you can't embed a window object
		inside a widget or another window. The parent object will just "own" this
		window object and eventually destroy it when it dies.
		This class can manage only a single central child widget that must
		be set with $setCentralWidget().
		The central widget MUST be set before you initially call show()
	@functions:
*/

bool KviScriptWindowObject::init(KviCommand *c)
{
	KviWindow * w = new KviScriptWindowWindow(c->window()->frame(),name());
	setObject(w);
	c->window()->frame()->addWindow(w,false);
	w->minimize(); // must be minimized before children are added, otherwise the focus handling goes nuts...
	return true;
}

#define windowFuncReg(__nam, __func) \
	g_pWindowClass->registerFunctionHandler(__nam, \
	(KviScriptObjectFunctionHandlerProc)(KVI_PTR2MEMBER(KviScriptWindowObject::__func)), \
	0, true);

void KviScriptWindowObject::registerSelf()
{
	KviScriptObjectClass * base = g_pScriptObjectController-> \
		lookupClass("widget");
	__range_valid(base);

	g_pWindowClass = new KviScriptObjectClass(base, "window",
		windowClassCreateInstance, true);

	windowFuncReg("setIcon", functionSetIcon);
	windowFuncReg("setCentralWidget",functionSetCentralWidget);
	windowFuncReg("setCaption",functionSetCaption);
}

void KviScriptWindowObject::unregisterSelf()
{
	delete g_pWindowClass;
    g_pWindowClass = 0;
}


bool KviScriptWindowObject::functionSetIcon(KviCommand * c,KviParameterList * p,KviStr & b)
{
	ENTER_STACK_FRAME(c,"window::setIcon");

//	KviStr * pIcon = p->safeFirst();

//	if(widget())((QWindow *)widget())->insertItem(pText->ptr());

	return c->leaveStackFrame();
}

bool KviScriptWindowObject::functionSetCaption(KviCommand * c,KviParameterList * p,KviStr & b)
{
	ENTER_STACK_FRAME(c,"window::setCaption");

	KviStr * pText = p->safeFirst();

	if(widget())
		((KviScriptWindowWindow *)widget())->setCaptionString(pText->ptr());

	return c->leaveStackFrame();
}

bool KviScriptWindowObject::functionSetCentralWidget(KviCommand * c,KviParameterList * p,KviStr & b)
{
	ENTER_STACK_FRAME(c,"window::setCentralWidget");

	KviStr * pWidget = p->safeFirst();

	KviScriptObject * ob = g_pScriptObjectController->lookupObject(pWidget->ptr());
	if(!ob)
	{
		c->warning(__tr("Can't find the widget object to add (%s)"),pWidget->ptr());
		return c->leaveStackFrame();
	}

	if(!ob->object())
	{
		c->warning(__tr("Invalid object"));
		return c->leaveStackFrame();
	}

	if(!ob->object()->isWidgetType())
	{
		c->warning(__tr("Can't add a non-widget object"));
		return c->leaveStackFrame();
	}

	if(!ob->inherits("KviScriptWidgetObject"))
	{
		c->warning(__tr("Can't add a non-widget object"));
		return c->leaveStackFrame();
	}

	if(widget())
		((KviScriptWindowWindow *)widget())->setCentralWidget((KviScriptWidgetObject *)ob,((KviScriptWidgetObject *)ob)->widget());

	return c->leaveStackFrame();
}


#include "m_class_window.moc"
