//============================================================================
//
//   File : optw_identity.cpp
//   Creation date : Tue Nov 14 2000 23:06:53 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//============================================================================

#include "optw_identity.h"

#include <qlineedit.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qmessagebox.h>
#include <qtimer.h>
#include <qtooltip.h>
#include <qvalidator.h>

#include "kvi_settings.h"
#include "kvi_options.h"
#include "kvi_locale.h"
#include "kvi_uparser.h" 
#include "kvi_app.h"
#include "kvi_window.h"
#include "kvi_console.h"
#include "kvi_optionswidget.h"
#include "kvi_filedialog.h"
#include "kvi_iconmanager.h"
#include "kvi_http.h"
#include "kvi_avatar.h"

//#warning "Info tips"


KviAvatarDownloadDialog::KviAvatarDownloadDialog(QWidget * par,const QString &szUrl)
: QDialog(par)
{
	setCaption(__tr2qs("Avatar Download - KVIrc"));

	m_szUrl = szUrl;

	QGridLayout * g = new QGridLayout(this,2,2,4,8);

	m_pOutput = new QLabel(__tr2qs("<center>Please wait while the avatar is being downloaded</center>"),this);
	g->addMultiCellWidget(m_pOutput,0,0,0,1);

	QPushButton * b = new QPushButton(__tr2qs("Abort"),this);
	g->addWidget(b,1,1);
	connect(b,SIGNAL(clicked()),this,SLOT(cancelClicked()));

	m_pRequest = new KviHttpRequest();
	
	QTimer::singleShot(0,this,SLOT(startDownload()));

	g->setRowStretch(0,1);
	g->setColStretch(0,1);

	setMinimumSize(250,120);
}

KviAvatarDownloadDialog::~KviAvatarDownloadDialog()
{
	delete m_pRequest;
}

void KviAvatarDownloadDialog::startDownload()
{
	connect(m_pRequest,SIGNAL(terminated(bool)),this,SLOT(downloadTerminated(bool)));
	connect(m_pRequest,SIGNAL(status(const char *)),this,SLOT(downloadMessage(const char *)));

	QString tmp = m_szUrl;
	g_pIconManager->urlToCachedFileName(tmp);
	g_pApp->getLocalKvircDirectory(m_szLocalFileName,KviApp::Avatars,tmp);

	m_pRequest->setExistingFileAction(KviHttpRequest::RenameExisting);
	if(!m_pRequest->get(KviUrl(m_szUrl),KviHttpRequest::StoreToFile,m_szLocalFileName.latin1()))
	{
		m_szErrorMessage = __tr2qs("Failed to start the download");
		reject();
	}
}

void KviAvatarDownloadDialog::closeEvent(QCloseEvent * e)
{
	m_szErrorMessage = __tr2qs("Download aborted by user");
	e->ignore();
	reject();
}

void KviAvatarDownloadDialog::cancelClicked()
{
	m_szErrorMessage = __tr2qs("Download aborted by user");
	reject();
}


void KviAvatarDownloadDialog::downloadMessage(const char * message)
{
	if(message)
	{
		QString txt = "<center>";
		txt += message;
		txt += "</center>";
		m_pOutput->setText(message);
	}
}


void KviAvatarDownloadDialog::downloadTerminated(bool bSuccess)
{
	if(bSuccess)
	{
		accept();
	} else {
		m_szErrorMessage = m_pRequest->lastError().ptr();
		reject();
	}
}



KviAvatarSelectionDialog::KviAvatarSelectionDialog(QWidget * par,const QString &szInitialPath)
: QDialog(par)
{
	setCaption(__tr2qs("Choose Avatar - KVIrc"));

	QGridLayout * g = new QGridLayout(this,3,3,4,8);
	

	QString msg = "<center>";
	msg += __tr2qs("Please select an avatar image. " \
				"The full path to a local file or an image on the Web can be used.<br>" \
				"If you wish to use a local image file, click the \"<b>Browse</b>\"" \
				"button to browse local folders.<br>" \
				"The full URL for an image (including <b>http://</b>) can be entered manually.");
	msg += "</center><br>";

	QLabel * l = new QLabel(msg,this);
	l->setMinimumWidth(250);

	g->addMultiCellWidget(l,0,0,0,2);

	m_pLineEdit = new QLineEdit(this);
	m_pLineEdit->setText(szInitialPath);
	m_pLineEdit->setMinimumWidth(180);

	g->addMultiCellWidget(m_pLineEdit,1,1,0,1);

	QPushButton * b = new QPushButton(__tr2qs("&Browse..."),this);
	connect(b,SIGNAL(clicked()),this,SLOT(chooseFileClicked()));
	g->addWidget(b,1,2);
	QHBox * h = new QHBox(this);h->setSpacing(8);g->addMultiCellWidget(h,2,2,1,2);
	b = new QPushButton(__tr2qs("&OK"),h);
	b->setMinimumWidth(80);
	b->setDefault(true);
	connect(b,SIGNAL(clicked()),this,SLOT(okClicked()));
	//g->addWidget(b,2,1);

	b = new QPushButton(__tr2qs("Cancel"),h);
	b->setMinimumWidth(80);
	connect(b,SIGNAL(clicked()),this,SLOT(cancelClicked()));
	//g->addWidget(b,2,2);
	
	g->setRowStretch(0,1);
	g->setColStretch(0,1);
	//setMinimumSize(250,120);
}

KviAvatarSelectionDialog::~KviAvatarSelectionDialog()
{
}

void KviAvatarSelectionDialog::okClicked()
{
	m_szAvatarName = m_pLineEdit->text();
	accept();
}

void KviAvatarSelectionDialog::cancelClicked()
{
	reject();
}

void KviAvatarSelectionDialog::chooseFileClicked()
{
	QString tmp;
 	if(KviFileDialog::askForOpenFileName(tmp,__tr2qs("Choose an Image File - KVIrc")))
	{
		m_pLineEdit->setText(tmp);
	}
}

void KviAvatarSelectionDialog::closeEvent(QCloseEvent * e)
{
	e->ignore();
	reject();
}





KviNickAlternativesDialog::KviNickAlternativesDialog(QWidget * par,const QString &n1,const QString &n2,const QString &n3)
: QDialog(par)
{
	QGridLayout * g = new QGridLayout(this,5,3,4,8);

	setCaption(__tr2qs("Nickname alternatives"));

	QLabel * l = new QLabel(this);
	l->setText(__tr2qs("<center>Here you can choose up to three nicknames " \
		"alternative to the primary one. KVIrc will use the alternatives " \
		"if the primary nick is already used by someone else on a particular " \
		"IRC network.</center>"));
	g->addMultiCellWidget(l,0,0,0,2);

	l = new QLabel(this);
	l->setText(__tr2qs("Alt. Nickname 1:"));
	g->addWidget(l,1,0);
	m_pNickEdit1 = new QLineEdit(this);
	g->addMultiCellWidget(m_pNickEdit1,1,1,1,2);
	m_pNickEdit1->setText(n1);

	l = new QLabel(this);
	l->setText(__tr2qs("Alt. Nickname 2:"));
	g->addWidget(l,2,0);
	m_pNickEdit2 = new QLineEdit(this);
	g->addMultiCellWidget(m_pNickEdit2,2,2,1,2);
	m_pNickEdit2->setText(n2);

	l = new QLabel(this);
	l->setText(__tr2qs("Alt. Nickname 3:"));
	g->addWidget(l,3,0);
	m_pNickEdit3 = new QLineEdit(this);
	g->addMultiCellWidget(m_pNickEdit3,3,3,1,2);
	m_pNickEdit3->setText(n3);
	QHBox * h = new QHBox(this);h->setSpacing(8);g->addWidget(h,4,2);	
	QPushButton * pb = new QPushButton(__tr2qs("Cancel"),h);
	//g->addWidget(pb,4,2);
	connect(pb,SIGNAL(clicked()),this,SLOT(reject()));

	pb = new QPushButton(__tr2qs("Ok"),h);
	pb->setDefault(true);
	connect(pb,SIGNAL(clicked()),this,SLOT(accept()));
	
	g->setColStretch(0,1);
	
	//setMinimumSize(250,120);
}

KviNickAlternativesDialog::~KviNickAlternativesDialog()
{
}

void KviNickAlternativesDialog::fill(QString &n1,QString &n2,QString &n3)
{
	n1 = m_pNickEdit1->text();
	n2 = m_pNickEdit2->text();
	n3 = m_pNickEdit3->text();
}



KviIdentityOptionsWidget::KviIdentityOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"identity_options_widget")
{
	m_szAltNicknames[0] = KviStr(KVI_OPTION_STRING(KviOption_stringNickname2));
	m_szAltNicknames[1] = KviStr(KVI_OPTION_STRING(KviOption_stringNickname3));
	m_szAltNicknames[2] = KviStr(KVI_OPTION_STRING(KviOption_stringNickname4));

	m_sModeStr = KVI_OPTION_STRING(KviOption_stringDefaultUserMode);    
	m_bI = m_sModeStr.contains('i');
	m_bW = m_sModeStr.contains('w');
	m_bS = m_sModeStr.contains('s');
    
	createLayout(3,1);

	QGroupBox * gbox = addGroupBox(0,0,0,0,1,QGroupBox::Horizontal,__tr2qs("Properties" ));
	QHBox * hb = new QHBox(gbox);
	hb->setSpacing(4);

	KviStringSelector * sel = addStringSelector(hb,__tr2qs("Nickname:"),KviOption_stringNickname1);
#ifdef COMPILE_INFO_TIPS
	mergeTip(sel,__tr2qs("<center>Your <b>nickname</b> is your primary form of identification on IRC.<br>" \
			"Since servers cannot accept multiple users sharing the same nickname " \
			"(case insensitive), you can provide alternative nicknames to be used in case"\
			"the server refuses to accept the default one.</center>"));
#endif
	QValidator * v = new QRegExpValidator(QRegExp("[^-0-9 ][^ ]*"),hb);
	sel->setValidator(v);
	
	QPushButton * pb = new QPushButton(__tr2qs("Alternatives..."),hb);
	connect(pb,SIGNAL(clicked()),this,SLOT(setNickAlternatives()));


	sel = addStringSelector(gbox,__tr2qs("Username:"),KviOption_stringUsername);
#ifdef COMPILE_INFO_TIPS
	mergeTip(sel,__tr2qs("<center>This is the <b>username</b> that you will use to connect to the server.<br>" \
				"In the past, it was used as a form of authentication, but it normally has no special use now.<br>" \
				"In addition to your nickname, you are identified on IRC by your <b>username@hostname</b>.</br>" \
				"Basically, you can enter any word you like here. :D</center>"));
#endif
	sel = addStringSelector(gbox,__tr2qs("Real name:"),KviOption_stringRealname);
#ifdef COMPILE_INFO_TIPS
	mergeTip(sel,__tr2qs("<center>This text will appear when someone does a /WHOIS on you.<br>" \
				"It is intended to be your real name, but people tend to put random quotes and phrases here too.</center>"));
#endif

	//m_pNickBox->setCurrentItem(m_iLastEditedNick);
	//m_pNickEdit->setText(m_NicksTable[m_iLastEditedNick].ptr());
	//connect(m_pNickBox,SIGNAL(highlighted(int)),this,SLOT(selectNick(int)));

	gbox = addGroupBox(0,1,0,1,1,QGroupBox::Horizontal,__tr2qs("User Mode" ));
	m_pISelector = addBoolSelector(gbox,__tr2qs("Invisible (+i)"),&m_bI);
	m_pSSelector = addBoolSelector(gbox,__tr2qs("Server notices (+s)"),&m_bS);
	m_pWSelector = addBoolSelector(gbox,__tr2qs("Wallops (+w)"),&m_bW);

	//bool b_Iscon = (g_pApp->activeWindow()->console() ? g_pApp->activeWindow()->console()->isConnected() : false);
	//m_pChangeButton->setEnabled(b_Iscon);

	//connect(m_pChangeButton,SIGNAL(clicked()),this,SLOT(changeNick()));
    
	//connect(m_pISelector,SIGNAL(toggled(bool)),this,SLOT(iModeCheckToggled(bool)));
	//connect(m_pWSelector,SIGNAL(toggled(bool)),this,SLOT(wModeCheckToggled(bool)));
	//connect(m_pSSelector,SIGNAL(toggled(bool)),this,SLOT(sModeCheckToggled(bool)));
    
	// AVATAR

	m_pLocalAvatar = new KviPixmap(KVI_OPTION_PIXMAP(KviOption_pixmapMyAvatar));

	bool bHaveAvatar = (!KVI_OPTION_STRING(KviOption_stringMyAvatar).isEmpty()) && m_pLocalAvatar->pixmap();

	gbox = addGroupBox(0,2,0,2,1,QGroupBox::Horizontal,__tr2qs("Avatar" ));

	m_pUseAvatarCheck = new QCheckBox(__tr2qs("Use avatar"),gbox);
	m_pUseAvatarCheck->setChecked(bHaveAvatar);

	m_pAvatarPreview = new KviPixmapPreview(gbox);
	m_pAvatarPreview->setPixmap(m_pLocalAvatar);
	m_pAvatarPreview->setEnabled(bHaveAvatar);
	connect(m_pUseAvatarCheck,SIGNAL(toggled(bool)),m_pAvatarPreview,SLOT(setEnabled(bool)));

	hb = new QHBox(gbox);
	hb->setSpacing(4);

	m_pAvatarNameEdit = new QLineEdit(hb);
	m_pAvatarNameEdit->setReadOnly(true);
	m_pAvatarNameEdit->setEnabled(bHaveAvatar);
	m_pAvatarNameEdit->setText(KVI_OPTION_STRING(KviOption_stringMyAvatar));
	connect(m_pUseAvatarCheck,SIGNAL(toggled(bool)),m_pAvatarNameEdit,SLOT(setEnabled(bool)));

	m_pChooseAvatarButton = new QPushButton(__tr2qs("Choose..."),hb);
	m_pChooseAvatarButton->setEnabled(bHaveAvatar);
	connect(m_pUseAvatarCheck,SIGNAL(toggled(bool)),m_pChooseAvatarButton,SLOT(setEnabled(bool)));

	connect(m_pChooseAvatarButton,SIGNAL(clicked()),this,SLOT(chooseAvatar()));

	//layout()->setRowStretch(12,1);
	//layout()->setColStretch(0,1);
}

KviIdentityOptionsWidget::~KviIdentityOptionsWidget()
{
	delete m_pLocalAvatar;
}

void KviIdentityOptionsWidget::commit(void)
{
	KviOptionsWidget::commit();

	KVI_OPTION_STRING(KviOption_stringNickname2) = m_szAltNicknames[0];
	KVI_OPTION_STRING(KviOption_stringNickname3) = m_szAltNicknames[1];
	KVI_OPTION_STRING(KviOption_stringNickname4) = m_szAltNicknames[2];

	m_sModeStr = m_bI ? "i" : "";
	if(m_bS)m_sModeStr += "s";
	if(m_bW)m_sModeStr += "w";

	KVI_OPTION_STRING(KviOption_stringDefaultUserMode) = m_sModeStr.ptr();

	QString szAvatarName = m_pAvatarNameEdit->text();

	if(m_pUseAvatarCheck->isChecked() && m_pLocalAvatar->pixmap() && (!szAvatarName.isEmpty()))
	{
		KVI_OPTION_STRING(KviOption_stringMyAvatar) = szAvatarName;
		KVI_OPTION_PIXMAP(KviOption_pixmapMyAvatar) = *m_pLocalAvatar;
		g_pApp->setAvatarFromOptions();
	} else {
		KVI_OPTION_STRING(KviOption_stringMyAvatar) = "";
		KVI_OPTION_PIXMAP(KviOption_pixmapMyAvatar) = KviPixmap();
	}
}

void KviIdentityOptionsWidget::setNickAlternatives()
{
	KviNickAlternativesDialog * dlg = new KviNickAlternativesDialog(this,m_szAltNicknames[0],m_szAltNicknames[1],m_szAltNicknames[2]);
	if(dlg->exec() != QDialog::Accepted)return;
	dlg->fill(m_szAltNicknames[0],m_szAltNicknames[1],m_szAltNicknames[2]);
	delete dlg;
}

void KviIdentityOptionsWidget::chooseAvatar()
{
	QString szCurrent = m_pAvatarNameEdit->text();

	KviAvatarSelectionDialog dlg(this,szCurrent);
	if(dlg.exec() != QDialog::Accepted)return;

	szCurrent = dlg.avatarName();
	szCurrent.stripWhiteSpace();

	if(KviQString::equalCIN(szCurrent,"http://",7))
	{
		// this is an url
		// first check if we have it in the cache
		KviAvatar * a = g_pIconManager->getAvatar(QString::null,szCurrent);
		if(!a)
		{
			// no cache... try downloading
			KviAvatarDownloadDialog dlg(this,szCurrent);
			if(dlg.exec() == QDialog::Accepted)
			{
				// downloaded!
				// try to load it
				if(!m_pLocalAvatar->load(dlg.localFileName().latin1()))
				{
					// unloadable
					szCurrent = "";
					QMessageBox::warning(this,__tr2qs("Failed to Load Avatar - KVIrc"),
						__tr2qs("Failed to load the avatar image.<br>" \
							"It may be an unaccessible file or an " \
							"unsupported image format."),QMessageBox::Ok,QMessageBox::NoButton);
				} // else loaded!
			} else {
				// unloadable
				QString tmp;
				KviQString::sprintf(tmp,__tr2qs("Failed to download the avatar image.<br>" \
					"<b>%Q</b>"),&(dlg.errorMessage()));
				QMessageBox::warning(this,__tr2qs("Avatar Download Failed - KVIrc"),tmp,QMessageBox::Ok,QMessageBox::NoButton);
				szCurrent = "";
				m_pLocalAvatar->setNull();
			}
		} else {
			// else OK.. got it in the cache
			m_pLocalAvatar->set(*(a->pixmap()),a->localPath());
			delete a;
		}
	} else {
		// this is a local path
		if(m_pLocalAvatar->load(szCurrent.latin1()))
		{
			// local path, loaded
			QString tmp = szCurrent;
			int idx = tmp.findRev("/");
			if(idx != -1)
			{
				szCurrent = tmp.right(tmp.length() - (idx + 1));
				tmp = szCurrent;
			}
			idx = tmp.findRev("\\");
			if(idx != -1)
			{
				szCurrent = tmp.right(tmp.length() - (idx + 1));
				tmp = szCurrent;
			}
		} else {
			// unloadable
			QMessageBox::warning(this,__tr2qs("Failed to Load Avatar - KVIrc"),
					__tr2qs("Failed to load the avatar image.<br>" \
						"It may be an unaccessible file or an " \
						"unsupported image format."),QMessageBox::Ok,QMessageBox::NoButton);
			szCurrent = "";
		}
	}

	m_pAvatarNameEdit->setText(szCurrent);
	m_pAvatarPreview->setPixmap(m_pLocalAvatar);
}    


#include "m_optw_identity.moc"
