//
//   File : optw_input.cpp
//   Creation date : Sat Aug 11 2001 04:25:52 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "optw_input.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

//#warning "Info tips"

KviInputLookOptionsWidget::KviInputLookOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ircviewlook_options_widget")
{
	createLayout(8,1);

	addFontSelector(0,0,0,0,__tr2qs("Font"),KviOption_fontInput);
	addColorSelector(0,1,0,1,__tr2qs("Background color"),KviOption_colorInputBackground);
	addColorSelector(0,2,0,2,__tr2qs("Foreground color"),KviOption_colorInputForeground);
	addColorSelector(0,3,0,3,__tr2qs("Selection background color"),KviOption_colorInputSelectionBackground);
	addColorSelector(0,4,0,4,__tr2qs("Selection foreground color"),KviOption_colorInputSelectionForeground);
	addColorSelector(0,5,0,5,__tr2qs("Control char color"),KviOption_colorInputControl);
	addColorSelector(0,6,0,6,__tr2qs("Cursor color"),KviOption_colorInputCursor);

	addPixmapSelector(0,7,0,7,__tr2qs("Background image"),KviOption_pixmapInputBackground);

	layout()->setRowStretch(7,1);
}

KviInputLookOptionsWidget::~KviInputLookOptionsWidget()
{
}



KviInputFeaturesOptionsWidget::KviInputFeaturesOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ircviewfeatures_options_widget")
{
	createLayout(2,1);

	addBoolSelector(0,0,0,0,__tr2qs("Warp cursor at the end of line when browsing history"),KviOption_boolInputHistoryCursorAtEnd);
	QGroupBox * g = addGroupBox(0,1,0,1,1,QGroupBox::Horizontal,__tr2qs("Nick completion"));
	addBoolSelector(g,__tr2qs("Use bash-like nick completion"),KviOption_boolBashLikeNickCompletion);
	addStringSelector(g,__tr2qs("Nick completion postfix string"),KviOption_stringNickCompletionPostfix);
	addBoolSelector(g,__tr2qs("Use the completion postfix string for the first word only"),KviOption_boolUseNickCompletionPostfixForFirstWordOnly);

	addRowSpacer(0,2,0,2);
}

KviInputFeaturesOptionsWidget::~KviInputFeaturesOptionsWidget()
{
}

#include "m_optw_input.moc"
