//
//   File : optw_interfacefeatures.cpp
//   Creation date : Sat Jun 2 2001 14:52:53 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_interfacefeatures.h"

#include <qlayout.h>
#include <qlabel.h>
#include <string.h>

#include "kvi_options.h"
#include "kvi_locale.h"


KviInterfaceFeaturesOptionsWidget::KviInterfaceFeaturesOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"interfacefeatures_options_widget")
{
	createLayout(4,1);

	addBoolSelector(0,0,0,0,__tr2qs("Confirm quit with active connections"),KviOption_boolConfirmCloseWhenThereAreConnections);
	addBoolSelector(0,1,0,1,__tr2qs("Remember window properties"),KviOption_boolWindowsRememberProperties);
	QGroupBox * g = addGroupBox(0,2,0,2,1,QGroupBox::Horizontal,__tr2qs("Open Dialog Window For"));
	addBoolSelector(g,__tr2qs("Preferences"),KviOption_boolShowGeneralOptionsDialogAsToplevel);
	addBoolSelector(g,__tr2qs("Registered Users"),KviOption_boolShowRegisteredUsersDialogAsToplevel);
	addBoolSelector(g,__tr2qs("Identity"),KviOption_boolShowIdentityDialogAsToplevel);
	addBoolSelector(g,__tr2qs("Servers"),KviOption_boolShowServersConnectDialogAsToplevel);
	addBoolSelector(g,__tr2qs("Join Channels"),KviOption_boolShowChannelsJoinDialogAsToplevel);
	addRowSpacer(0,3,0,3);
}

KviInterfaceFeaturesOptionsWidget::~KviInterfaceFeaturesOptionsWidget()
{
}


#include "m_optw_interfacefeatures.moc"
