//
//   File : optw_notify.cpp
//   Creation date : Sun Oct 28 15:11:29 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_notify.h"

#include <qlayout.h>
#include "kvi_settings.h"
#include "kvi_options.h"
#include "kvi_locale.h"


//#warning "Info tips"


KviNotifyOptionsWidget::KviNotifyOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"notify_options_widget")
{
	createLayout(5,1);

	KviBoolSelector * b = addBoolSelector(0,0,0,0,__tr2qs("Use online notify list"),KviOption_boolUseNotifyList);
	QGroupBox *g = addGroupBox(0,1,0,1,1,QGroupBox::Horizontal,__tr2qs("Configuration"));
	connect(b,SIGNAL(toggled(bool)),g,SLOT(setEnabled(bool)));

	connect(b,
		SIGNAL(toggled(bool)),
		addBoolSelector(g,__tr2qs("Show notifications in active window"),
				KviOption_boolNotifyListChangesToActiveWindow,KVI_OPTION_BOOL(KviOption_boolUseNotifyList)),
		SLOT(setEnabled(bool)));
	connect(b,
		SIGNAL(toggled(bool)),
		addBoolSelector(g,__tr2qs("Flash window when users are going online"),
				KviOption_boolFlashWindowOnNotifyOnLine,KVI_OPTION_BOOL(KviOption_boolUseNotifyList)),
		SLOT(setEnabled(bool)));
	connect(b,
		SIGNAL(toggled(bool)),
		addBoolSelector(g,__tr2qs("Popup notifier when users are going online"),
				KviOption_boolPopupNotifierOnNotifyOnLine,KVI_OPTION_BOOL(KviOption_boolUseNotifyList)),
		SLOT(setEnabled(bool)));

	g = addGroupBox(0,2,0,2,1,QGroupBox::Horizontal,__tr2qs("Advanced configuration"));
	connect(b,SIGNAL(toggled(bool)),g,SLOT(setEnabled(bool)));

	connect(b,
		SIGNAL(toggled(bool)),
		addBoolSelector(g,__tr2qs("Check USERHOST for online users"),
				KviOption_boolNotifyListSendUserhostForOnlineUsers,KVI_OPTION_BOOL(KviOption_boolUseNotifyList)),
		SLOT(setEnabled(bool)));
	connect(b,
		SIGNAL(toggled(bool)),
		addBoolSelector(g,__tr2qs("Use \"smart\" notify list manager"),
				KviOption_boolUseIntelligentNotifyListManager,KVI_OPTION_BOOL(KviOption_boolUseNotifyList)),
		SLOT(setEnabled(bool)));
	connect(b,
		SIGNAL(toggled(bool)),
		addBoolSelector(g,__tr2qs("Use the WATCH method if available"),
				KviOption_boolUseWatchListIfAvailable,KVI_OPTION_BOOL(KviOption_boolUseNotifyList)),
		SLOT(setEnabled(bool)));
	connect(b,
		SIGNAL(toggled(bool)),
		addUIntSelector(g,__tr2qs("Check interval (in seconds)"),
				KviOption_uintNotifyListCheckTimeInSecs,
				5,3600,180,KVI_OPTION_BOOL(KviOption_boolUseNotifyList)),
		SLOT(setEnabled(bool)));
	connect(b,
		SIGNAL(toggled(bool)),
		addUIntSelector(g,__tr2qs("ISON delay (in seconds)"),
				KviOption_uintNotifyListIsOnDelayTimeInSecs,
				5,180,6,KVI_OPTION_BOOL(KviOption_boolUseNotifyList)),
		SLOT(setEnabled(bool)));
	connect(b,
		SIGNAL(toggled(bool)),
		addUIntSelector(g,__tr2qs("USERHOST delay (in seconds)"),
				KviOption_uintNotifyListUserhostDelayTimeInSecs,
				5,180,6,KVI_OPTION_BOOL(KviOption_boolUseNotifyList)),
		SLOT(setEnabled(bool)));

	addLabel(0,3,0,3,__tr2qs("<p><b>Note:</b><br>The notify list is managed using the \"Registered Users\" settings.</p>"));
	addRowSpacer(0,4,0,4);
}

KviNotifyOptionsWidget::~KviNotifyOptionsWidget()
{
}




KviNotifierOptionsWidget::KviNotifierOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"notifier_options_widget")
{
	createLayout(2,1);

	KviBoolSelector * b = addBoolSelector(0,0,0,0,__tr2qs("Forcibly and completely disable the notifier"),KviOption_boolForciblyDisableNotifier);
#ifdef COMPILE_INFO_TIPS
	QString tip = "<center>";
	tip += __tr2qs("This is an option for the impatient: it allows to forcibly and permanently disable " \
					"the notifier window. Please note that if this option is activated then " \
					"the notifier will NOT popup even if all the other options around specify " \
					"to use it in response to particular events. Also note that this option " \
					"will make all the /notifier.* commands fail silently.");
	tip += "</center>";
	mergeTip(b,tip);
#endif

	addRowSpacer(0,1,0,1);
}

KviNotifierOptionsWidget::~KviNotifierOptionsWidget()
{
}


#include "m_optw_notify.moc"
