//
//   File : optw_sound.cpp
//   Creation date : Fri Sep  6 02:18:23 2002 GMT by Szymon Stefanek
//
//   This file is part of the KVsound sound client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma at kvsound dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_sound.h"

#include "kvi_settings.h"
#include "kvi_locale.h"
#include "kvi_options.h"
#include "kvi_modulemanager.h"
#include "kvi_list.h"
#include "kvi_string.h"

#include <qlabel.h>
#include <qpushbutton.h>

// FIXME: This module doesn't Cancel properly when auto-detection is performed!

KviSoundOptionsWidget::KviSoundOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"sound_options_widget")
{
	createLayout(2,3);

	addLabel(0,0,0,0,__tr2qs("Sound system:"));

	m_pSoundSystemBox = new QComboBox(false,this);
	addWidgetToLayout(m_pSoundSystemBox,1,0,1,0);

	m_pAutoDetectButton = new QPushButton(__tr2qs("Auto-detect"),this);
	addWidgetToLayout(m_pAutoDetectButton,0,1,0,1);
	connect(m_pAutoDetectButton,SIGNAL(clicked()),this,SLOT(autoDetect()));

	m_pTestButton = new QPushButton(__tr2qs("Test"),this);
	addWidgetToLayout(m_pTestButton,1,1,1,1);
	connect(m_pTestButton,SIGNAL(clicked()),this,SLOT(test()));

	addRowSpacer(0,2,1,2);

	fillBox();
	// FIXME!
	m_pTestButton->setEnabled(false);
}


KviSoundOptionsWidget::~KviSoundOptionsWidget()
{
}

void KviSoundOptionsWidget::test()
{
}

void KviSoundOptionsWidget::autoDetect()
{
	KviModule * m = g_pModuleManager->getModule("snd");
	if(!m)return;
	m->ctrl("detectSoundSystem",0);
	fillBox();
}

void KviSoundOptionsWidget::fillBox()
{
	KviPtrList<KviStr> l;
	l.setAutoDelete(true);

	int cnt;

	KviModule * m = g_pModuleManager->getModule("snd");


	if(!m)goto disable;


	if(!m->ctrl("getAvailableSoundSystems",&l))goto disable;

	m_pSoundSystemBox->clear();

	for(KviStr * s = l.first();s;s = l.next())
	{
		m_pSoundSystemBox->insertItem(s->ptr());
	}

	cnt = m_pSoundSystemBox->count();

	for(int i=0;i<cnt;i++)
	{
		QString t = m_pSoundSystemBox->text(i);
		if(KviQString::equalCI(t,KVI_OPTION_STRING(KviOption_stringSoundSystem)))
		{
			m_pSoundSystemBox->setCurrentItem(i);
			break;
		}
	}

	return;
disable:
	m_pSoundSystemBox->clear();
	m_pSoundSystemBox->setEnabled(false);
	m_pTestButton->setEnabled(false);
	m_pAutoDetectButton->setEnabled(false);
}

void KviSoundOptionsWidget::commit()
{
	KviOptionsWidget::commit();
	KVI_OPTION_STRING(KviOption_stringSoundSystem) = m_pSoundSystemBox->currentText();
}

#include "m_optw_sound.moc"
