MODULE = KVIrc		PACKAGE = KVIrc
		
void echo(text,colorset = 0,windowid = 0)
	char * text
	int colorset
	char * windowid
	CODE:
		if(g_pCurrentCommand && text)
		{
			KviWindow * pWnd;
			if(windowid)
			{
				pWnd = g_pApp->findWindow(windowid);
				if(!pWnd)pWnd = g_pCurrentCommand->window();
			} else {
				pWnd = g_pCurrentCommand->window();
			}
			pWnd->outputNoFmt(colorset,QString::fromUtf8(text));
		}
		
void say(text,windowid = 0)
	char * text
	char * windowid
	CODE:
		if(g_pCurrentCommand && text)
		{
			KviWindow * pWnd;
			if(windowid)
			{
				pWnd = g_pApp->findWindow(windowid);
				if(!pWnd)pWnd = g_pCurrentCommand->window();
			} else {
				pWnd = g_pCurrentCommand->window();
			}
			KviStr szText(text);
			g_pUserParser->parseUserCommand(szText,pWnd);
		}

void warning(text)
	char * text
	CODE:
		if((!g_bExecuteQuiet) && g_pCurrentCommand)
			g_pCurrentCommand->warning(text);

char * getLocal(varname)
	char * varname
	CODE:
		if(g_pCurrentCommand)
		{
			KviStr * pVar = g_pCurrentCommand->dataContainer()->lookupVariable(varname,true);
			if(pVar)RETVAL = pVar->ptr();
			else RETVAL = "";
		}
	OUTPUT:
		RETVAL

void setLocal(varname,value)
	char * varname
	char * value
	CODE:
		if(g_pCurrentCommand)
		{
			if(value && *value)
			{
				KviStr * pVar = g_pCurrentCommand->dataContainer()->lookupVariable(varname,false);
				if(pVar)*pVar = value;
			} else {
				g_pCurrentCommand->dataContainer()->removeVariable(varname);
			}
		}

char * getGlobal(varname)
	char * varname
	CODE:
		KviStr * pVar = g_pUserParser->globalDataContainer()->lookupVariable(varname,true);
		if(pVar)RETVAL = pVar->ptr();
		else RETVAL = "";
	OUTPUT:
		RETVAL

void setGlobal(varname,value)
	char * varname
	char * value
	CODE:
		if(value && *value)
		{
			KviStr * pVar = g_pUserParser->globalDataContainer()->lookupVariable(varname,false);
			if(pVar)*pVar = value;
		} else {
			g_pUserParser->globalDataContainer()->removeVariable(varname);
		}

char * eval(code)
	char * code
	CODE:
		if(g_pCurrentCommand)
		{
			KviCommand cmd(code,g_pCurrentCommand->window(),g_pCurrentCommand);
			if(!g_pUserParser->parseCommand(&cmd))
			{
				if(cmd.hasError())
					g_pUserParser->printError(&cmd);
			}
			g_szLastReturnValue = cmd.returnValue();
			RETVAL = g_szLastReturnValue.ptr();
		} else {
			RETVAL = "";
		}
	OUTPUT:
		RETVAL

