//
//   File : optw_input.cpp
//   Creation date : Sat Aug 11 2001 04:25:52 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "optw_input.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

//#warning "Info tips"

KviInputLookOptionsWidget::KviInputLookOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ircviewlook_options_widget")
{
	createLayout(10,2);

	addFontSelector(0,0,1,0,__tr2qs_ctx("Font","options"),KviOption_fontInput);
	addColorSelector(0,1,1,1,__tr2qs_ctx("Background color","options"),KviOption_colorInputBackground);
	addColorSelector(0,2,1,2,__tr2qs_ctx("Foreground color","options"),KviOption_colorInputForeground);
	addColorSelector(0,3,1,3,__tr2qs_ctx("Selection background color","options"),KviOption_colorInputSelectionBackground);
	addColorSelector(0,4,1,4,__tr2qs_ctx("Selection foreground color","options"),KviOption_colorInputSelectionForeground);
	addColorSelector(0,5,1,5,__tr2qs_ctx("Control char color","options"),KviOption_colorInputControl);
	addColorSelector(0,6,1,6,__tr2qs_ctx("Cursor color","options"),KviOption_colorInputCursor);

	addLabel(0,7,0,7,__tr2qs_ctx("Horisontal align:","options"));
	m_pHorisontalAlign=new QComboBox(this);
	addWidgetToLayout(m_pHorisontalAlign,1,7,1,7);
	
	addLabel(0,8,0,8,__tr2qs_ctx("Vertical align:","options"));
	m_pVerticalAlign=new QComboBox(this);
	addWidgetToLayout(m_pVerticalAlign,1,8,1,8);
	
	m_pHorisontalAlign->insertItem(__tr2qs_ctx("Tile","options"));
	m_pHorisontalAlign->insertItem(__tr2qs_ctx("Left","options"));
	m_pHorisontalAlign->insertItem(__tr2qs_ctx("Right","options"));
	m_pHorisontalAlign->insertItem(__tr2qs_ctx("Center","options"));
	
	m_pVerticalAlign->insertItem(__tr2qs_ctx("Tile","options"));
	m_pVerticalAlign->insertItem(__tr2qs_ctx("Top","options"));
	m_pVerticalAlign->insertItem(__tr2qs_ctx("Bottom","options"));
	m_pVerticalAlign->insertItem(__tr2qs_ctx("Center","options"));
	
	switch( KVI_OPTION_UINT(KviOption_uintInputPixmapAlign) & Qt::AlignHorizontal_Mask)
	{
		case Qt::AlignLeft:
			m_pHorisontalAlign->setCurrentItem(1);
			break;
		case Qt::AlignRight:
			m_pHorisontalAlign->setCurrentItem(2);
			break;
		case Qt::AlignHCenter:
			m_pHorisontalAlign->setCurrentItem(3);
			break;
		default:
			m_pHorisontalAlign->setCurrentItem(0);
	}
	
	switch( KVI_OPTION_UINT(KviOption_uintInputPixmapAlign) & Qt::AlignVertical_Mask)
	{
		case Qt::AlignTop:
			m_pVerticalAlign->setCurrentItem(1);
			break;
		case Qt::AlignBottom:
			m_pVerticalAlign->setCurrentItem(2);
			break;
		case Qt::AlignVCenter:
			m_pVerticalAlign->setCurrentItem(3);
			break;
		default:
			m_pVerticalAlign->setCurrentItem(0);
	}

	addPixmapSelector(0,9,1,9,__tr2qs_ctx("Background image","options"),KviOption_pixmapInputBackground);

	layout()->setRowStretch(9,1);
}

KviInputLookOptionsWidget::~KviInputLookOptionsWidget()
{
}

void KviInputLookOptionsWidget::commit()
{
	int iFlags=0;
	switch(m_pHorisontalAlign->currentItem())
	{
		case 1:
			iFlags|=Qt::AlignLeft;
			break;
		case 2:
			iFlags|=Qt::AlignRight;
			break;
		case 3:
			iFlags|=Qt::AlignHCenter;
			break;
	}
	switch(m_pVerticalAlign->currentItem())
	{
		case 1:
			iFlags|=Qt::AlignTop;
			break;
		case 2:
			iFlags|=Qt::AlignBottom;
			break;
		case 3:
			iFlags|=Qt::AlignVCenter;
			break;
	}
	
	KVI_OPTION_UINT(KviOption_uintInputPixmapAlign)=iFlags;
	KviOptionsWidget::commit();
}



KviInputFeaturesOptionsWidget::KviInputFeaturesOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ircviewfeatures_options_widget")
{
	createLayout(6,1);

	addBoolSelector(0,0,0,0,__tr2qs_ctx("Warp cursor at the end of line when browsing history","options"),KviOption_boolInputHistoryCursorAtEnd);
	addBoolSelector(0,1,0,1,__tr2qs_ctx("Disable the input history window and it's log memory.","options"),KviOption_boolDisableInputHistory); //G&N 2005
	addBoolSelector(0,2,0,2,__tr2qs_ctx("Hide input toolbuttons by default","options"),KviOption_boolHideInputToolButtons);
	QGroupBox * g = addGroupBox(0,3,0,3,1,QGroupBox::Horizontal,__tr2qs_ctx("Nick completion","options"));
	addBoolSelector(g,__tr2qs_ctx("Use bash-like nick completion","options"),KviOption_boolBashLikeNickCompletion);
	addStringSelector(g,__tr2qs_ctx("Nick completion postfix string","options"),KviOption_stringNickCompletionPostfix);
	addBoolSelector(g,__tr2qs_ctx("Use the completion postfix string for the first word only","options"),KviOption_boolUseNickCompletionPostfixForFirstWordOnly);
	addBoolSelector(0,4,0,4,__tr2qs_ctx("Commandline in user-friendly mode by default","options"),KviOption_boolCommandlineInUserFriendlyModeByDefault);
	addRowSpacer(0,5,0,5);
}

KviInputFeaturesOptionsWidget::~KviInputFeaturesOptionsWidget()
{
}

#include "m_optw_input.moc"
