// =============================================================================
//
//      --- kvi_treelistdialog_qt.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qheader.h>
#include <qlayout.h>
#include <qsplitter.h>
#include <qstringlist.h>
#include <qvbox.h>
#include <qwidgetstack.h>

#include "kvi_defines.h"
#include "kvi_label.h"
#include "kvi_locale.h"
#include "kvi_listview.h"
#include "kvi_pushbutton.h"
#include "kvi_string.h"
#include "kvi_treelistdialog_qt.h"

KviTreeListDialog::KviTreeListDialog(QWidget *parent, const char *name, bool modal, const QString &caption, int /* ignored */)
	: QWidget(parent, name)
{
	setCaption(caption);
	m_pPages.setAutoDelete(true);

	QGridLayout *g1 = new QGridLayout(
		this, 2, 4, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE
	);
	QSplitter *spl = new QSplitter(QSplitter::Horizontal, this);
	g1->addMultiCellWidget(spl, 0, 0, 0, 3);
	// Controlling list view
	m_pListView = new KviListView(spl);
	m_pListView->setRootIsDecorated(true);
	m_pListView->header()->hide();
	m_pListView->addColumn(QString::null);
	m_pListView->setSorting(0);
	connect(
		m_pListView, SIGNAL(currentChanged(KviListViewItem *)),
		this, SLOT(listViewItemSelectionChanged(KviListViewItem *))
	);
	spl->setResizeMode(m_pListView, QSplitter::FollowSizeHint);
	spl->setChildrenCollapsible(false);
	spl->setOpaqueResize();

	// Widget stack
	m_pWidgetStack = new QWidgetStack(spl);

	// OK, Cancel, Help
	KviPushButton *b;
	b = new KviPushButton(_i18n_("What is &This?"), this);
	connect(b, SIGNAL(clicked()), this, SIGNAL(helpClicked()));
	g1->addWidget(b, 1, 1);

	b = new KviPushButton(_i18n_("&OK"), this);
	connect(b, SIGNAL(clicked()), this, SIGNAL(okClicked()));
	g1->addWidget(b, 1, 2);
	b->setDefault(true);

	b = new KviPushButton(_i18n_("&Cancel"), this);
	connect(b, SIGNAL(clicked()), this, SIGNAL(cancelClicked()));
	g1->addWidget(b, 1, 3);

	g1->setRowStretch(0, 1);
	g1->setColStretch(0, 1);
}

KviTreeListDialog::~KviTreeListDialog()
{
	// Nothing here
}

void KviTreeListDialog::listViewItemSelectionChanged(KviListViewItem *item)
{
	QWidget *w = m_pPages.find(item);
	emit aboutToShowPage(w);
	m_pWidgetStack->raiseWidget((QWidget *) w->parent());
}

void KviTreeListDialog::delayedDestruct()
{
	delete this; // Is this safe?
}

void KviTreeListDialog::setButtonHelpText(const QString & /* ignored */)
{
	// Nothing here
}

QVBox *KviTreeListDialog::addVBoxPage(const QStringList &items, const QString &header, const QPixmap &pixmap)
{
	KviListViewItem *parent = 0;
	QString name;
	for( QStringList::ConstIterator iter = items.begin(); iter != items.constEnd(); ++iter ) {
		name = QString(*iter);
		if( name == items.last() )
			break;
		if( parent ) {
			KviListViewItem *child = parent->firstChild();
			for( ; child; child = child->nextSibling() )
				if( child->text(0) == name ) break;
			if( child )
				parent = child;
		} else parent = findTopLevelItem(name);
	}
	KviListViewItem *item;
	if( parent )
		item = new KviListViewItem(parent, name);
	else
		item = new KviListViewItem(m_pListView, name);
	item->setPixmap(0, pixmap);

	QVBox *box = new QVBox(m_pWidgetStack);
	KviLabel *label = new KviLabel(header, box);
	// Set bold font for the title
	QFont titleFont(label->font());
	titleFont.setBold(true);
	label->setFont(titleFont);
	QVBox *box2 = new QVBox(box);
	box->setStretchFactor(box2, 1);

	m_pPages.insert(item, box2);
	return box2;
}

KviListViewItem *KviTreeListDialog::findTopLevelItem(const QString &name)
{
	for( KviListViewItem *item = m_pListView->firstChild(); item; item = item->nextSibling() )
		if( item->text(0) == name ) return item;
	return 0;
}

#include "m_kvi_treelistdialog_qt.moc"
