#ifndef _KVI_DCC_VOICE_H_INCLUDED_
#define _KVI_DCC_VOICE_H_INCLUDED_

// =============================================================================
//
//      --- kvi_dcc_voice.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_dcc_voice_thread.h"
#include "kvi_string.h"
#include "kvi_window.h"

class KviLabel;
class KviPushButton;

class KviDccVoice : public KviWindow
{
	Q_OBJECT
public:
	KviDccVoice(KviFrame *lpFrm, const char *name);
	~KviDccVoice();
public:
	void acceptDccRequest(const char *nick, const char *name, const char *host, unsigned long addr, unsigned short port);
	void requestDcc(const char *nick, const char *username, const char *host);
protected:
	virtual QPixmap *myIconPtr();
	virtual void     resizeEvent(QResizeEvent *);
	virtual void     applyOptions();
	virtual bool     event(QEvent *);

	int checkSoundCard(KviDccVoiceData *dcc);
	void abortThread();

	KviDccVoiceThread *m_thread;
	KviDccVoiceData   *m_pData;
	KviStr             m_szRemoteNick;
	KviStr             m_szRemoteMask;
	KviStr             m_szLocalNick;
	KviStr             m_szLocalMask;
	KviLabel          *m_pStatLabel;
	KviPushButton     *m_pTalkButton;
protected slots:
	void talkPressed();
	void talkReleased();
};

#endif // _KVI_DCC_VOICE_H_INCLUDED_
